% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_genes.R
\name{all_genes}
\alias{all_genes}
\title{Get all genes}
\usage{
all_genes(
  species,
  method = c("gprofiler", "homologene", "babelgene"),
  ensure_filter_nas = FALSE,
  run_map_species = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{species}{Species to get all genes for.
Will first be standardised with \code{map_species}.}

\item{method}{R package to use for gene mapping:
\describe{
 \item{\code{"gprofiler"}}{Slower but more species and genes.}
 \item{\code{"homologene"}}{Faster but fewer species and genes.}
 \item{\code{"babelgene"}}{Faster but fewer species and genes.
 Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{ensure_filter_nas}{Perform an extra check to remove
genes that are \code{NA}s of any kind.}

\item{run_map_species}{Standardise \code{species} names with 
\link[orthogene]{map_species} first (Default: \code{TRUE}).}

\item{verbose}{Print messages.}

\item{...}{Additional arguments to be passed to
\link[gprofiler2]{gorth} or \link[homologene]{homologene}.\cr\cr
\emph{NOTE}: To return only the most "popular"
interspecies ortholog mappings,
supply \code{mthreshold=1} here AND set \code{method="gprofiler"} above.
This procedure tends to yield a greater number of returned genes but at
 the cost of many of them not being true biological 1:1 orthologs.\cr\cr
 For more details, please see
\href{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}{
 here}.}
}
\value{
Table with all gene symbols
 from the given \code{species}.
}
\description{
Return all known genes from a given species.
}
\details{
References \link[homologene]{homologeneData} or
\link[gprofiler2]{gconvert}.
}
\examples{
genome_mouse <- all_genes(species = "mouse")
genome_human <- all_genes(species = "human")
}
