% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_merge.R
\name{peak_merge}
\alias{peak_merge}
\title{Merge adjacent peaks within H3K4me3 or Pol II data.}
\usage{
peak_merge(peak, n = 250)
}
\arguments{
\item{peak}{A \code{GRange} object. The peaks to be merged from one certain
ChIP-seq data, such as H3K4me3 data or Pol II data.}

\item{n}{A number. \code{n} stipulates the distance(bp, base pair) between
two seperate peaks within which they should be merged.}
}
\value{
A GRanges object. The merged peaks for the following analysis to
  search for TSSs.
}
\description{
Merge the adjacent segments provided as \code{GRange} object from original
data. This function will merge adjacent peaks the distance between which is
less than n base pairs apart and then return the merged segments.
}
\examples{
peak_df <- data.frame(chrom = c("chr1", "chr2", "chr1"),
                      chromStart = c(450, 460, 680),
                      chromEnd = c(470, 480, 710),
                      stringsAsFactors = FALSE)
peak <-  as(peak_df, "GRanges")

peak_merge(peak, n =250)

}
