% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalization.R
\name{normalization}
\alias{normalization}
\title{normalization: Normalization for single-cell RNA-seq data}
\usage{
normalization(counts)
}
\arguments{
\item{counts}{A non-negative integer matrix of scRNA-seq raw read counts or a \code{SingleCellExperiment} object which contains the read counts matrix. The rows of the matrix are genes and columns are samples/cells.}
}
\value{
A normalized scRNA-seq read counts matrix.
}
\description{
This function is used to normalize single-cell RNA-seq (scRNA-seq) data. It takes a non-negative matrix of scRNA-seq raw read counts or a \code{SingleCellExperiment} object as input.
}
\examples{
# Load test data
data(scRecoverTest)

# Normalization of counts
counts.norm <- normalization(counts = counts)


}
\seealso{
\code{\link{scRecover}}, for imputation of single-cell RNA-seq data.

\code{\link{estDropoutNum}}, for estimating dropout gene number in a cell.

\code{\link{countsSampling}}, for downsampling the read counts in a cell.

\code{\link{scRecoverTest}}, a test dataset for scRecover.
}
\author{
Zhun Miao.
}
