% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ks_sig.R
\name{ks_sig}
\alias{ks_sig}
\title{ks_sig}
\usage{
ks_sig(ks.pval.unadj)
}
\arguments{
\item{ks.pval.unadj}{The output from \code{ks_test} which is a list
of p-values from the KS test with gene names.}
}
\value{
List object containing the significant gene indices from the KS test,
their adjusted p-values
}
\description{
This function is used to select genes significant from the
\code{ks_test}.
}
\examples{

data(scData)

# apply the ks_test function to subset genes belonging to the
# family of ZINB distributions.

library(BiocParallel)
scData_KS <- ks_test(counts=scData$counts, cexpr=scData$covariates, lib.size=scData$lib_size, BPPARAM=bpparam())

# apply the ks_sig function to select genes significant from
# the Kolmogorov Smirnov test.

scData_KS_sig <- ks_sig(scData_KS)
}
