% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbic_model.R
\name{lbic_model}
\alias{lbic_model}
\title{lbic_model}
\usage{
lbic_model(bic.value, counts)
}
\arguments{
\item{bic.value}{A dataframe of BIC values from fitting GLM using
error distributions P, NB, ZIP, ZINB; the output from \code{model_bic}.}

\item{counts}{A non-negative integer matrix of scRNA-seq filtered read counts
containing genes belonging to the family of ZINB distributions selected from
\code{ks_test}.
The rows of the matrix are genes and columns are samples/cells.}
}
\value{
A list of genes chosen to be following one of the 4 distributions
P, NB, ZIP, ZINB based on the least BIC value and the corresponding subset
of counts from \code{filter_counts}
}
\description{
This function is used to select the best fit model for each gene based on the
least BIC value
}
\examples{

data(scData)

# apply the lbic_model function to select the model with the least
# BIC value on the matrix of BIC values obtained after running
# model_bic function.

library(BiocParallel)
scData_models <- fit_models(counts=scData$counts, cexpr=scData$covariates, lib.size=scData$lib_size,
BPPARAM=bpparam())

scData_bicvals <- model_bic(scData_models)

scData_least.bic <- lbic_model(scData_bicvals, scData$counts)
}
