% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{debug}
\alias{debug}
\title{Internal function}
\usage{
debug(y, z, dist, phi, pi, gamma, test, iter, kind, ...)
}
\arguments{
\item{y}{\strong{observations:}
numeric vector of length \code{n}}

\item{z}{\strong{class labels:}
integer vector of length \code{n},
with entries \code{0}, \code{1} and \code{NA}}

\item{dist}{distributional assumption\strong{:}
character \code{"norm"} (Gaussian),
\code{"nbinom"} (negative bionomial),
or \code{"zinb"} (zero-inflated negative binomial)}

\item{phi}{dispersion parameters\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{pi}{zero-inflation parameter(s)\strong{:}
numeric vector of length \code{q},
or \code{NULL}}

\item{gamma}{offset\strong{:}
numeric vector of length \code{n},
or \code{NULL}}

\item{test}{resampling procedure\strong{:}
character \code{"perm"} (permutation) or
\code{"boot"} (parametric bootstrap),
or \code{NULL}}

\item{iter}{(maximum) number of resampling iterations \strong{:}
positive integer, or \code{NULL}}

\item{kind}{resampling accuracy\strong{:}
numeric between \code{0} and \code{1}, or \code{NULL}\strong{;}
all \code{p}-values above \code{kind} are approximate}

\item{...}{settings \code{EM} algorithm\strong{:}
\code{starts}, \code{it.em} and \code{epsilon}
(see \code{\link{arguments}})}
}
\value{
This function returns warnings and errors.
It also returns \code{kind} (see details).
}
\description{
This function verifies whether the arguments fulfill some formal requirements.
}
\details{
If one or more entries of \code{z} are equal to \code{1},
the mixture model can be fitted but not tested.
Accordingly, \code{kind} is replaced by \code{NULL}.

Resampling-based testing cannot reach \code{p}-values below \code{1/iter}.
If \code{kind} is smaller than \code{1/iter}, it is replaced by \code{0}.
}
\examples{
NULL

}
\seealso{
This is an \code{\link{internal}} function.
The user functions are \code{\link{mixtura}} and \code{\link{scrutor}}.
}
\keyword{internal}
