% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/withLoader.R
\name{withLoader}
\alias{withLoader}
\title{Add a loader to a Shiny UI element}
\usage{
withLoader(ui_element, loader = "biocspin", proxy.height = "400px")
}
\arguments{
\item{ui_element}{A Shiny UI element (e.g., \code{uiOutput}, \code{plotOutput}, etc.)
for which to wrap with the loader.}

\item{loader}{\code{character(1)} A string specifying the loader type. Default is
"biocspin".}

\item{proxy.height}{\code{character(1)} A string specifying the height of the
proxy element. Default is "400px". If the \code{ui_element} already has a
height specified, this will be set to "100\%".}
}
\value{
A Shiny UI element wrapped with the Bioconductor loader
}
\description{
Add a loader to a Shiny UI element
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(shinydashboard)
library(shinybiocloader)

waitHist <- function() {
  waiting <- faithful[["waiting"]]
  Sys.sleep(3)  # Simulate loading
  hist(
    waiting, col = 'darkgray', border = 'white',
    main = 'Old Faithful Geyser Waiting Times Histogram',
    xlab = 'Waiting Time (min)'
  )
}

ui <- dashboardPage(
  dashboardHeader(title = "Bioconductor Loader"),
  dashboardSidebar(disable = TRUE),
  dashboardBody(
    h2("Bioconductor Spinning Loader"),
    HTML(
      paste0(
        "<pre><code class='language-r'>",
        "withLoader(plotOutput('distPlot'), loader='biocspin')",
        "</code></pre>"
      )
    ),
    fluidRow(
      box(
        title = "With Loader", status = "primary", solidHeader = TRUE,
        withLoader(plotOutput("distPlot"), loader = "biocspin")
      ),
      box(
        title = "Without Loader", status = "warning", solidHeader = TRUE,
        plotOutput("distPlot2")
      )
    )
  )
)

server <- function(input, output) {
  output$distPlot <- renderPlot(waitHist())
  output$distPlot2 <- renderPlot(waitHist())
}

shinyApp(ui = ui, server = server)
\dontshow{\}) # examplesIf}
}
\references{
\code{shinycustomloader} https://github.com/emitanaka/shinycustomloader

\verb{dna spin} https://codepen.io/knut/pen/ZopMWW
}
