% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opt_bar.R
\name{opt_bar}
\alias{opt_bar}
\title{Bar plots of co-clustering optimization results.}
\usage{
opt_bar(
  df.res,
  para.na,
  bar.width = 0.8,
  thr = NULL,
  title = NULL,
  title.size = 25,
  xlab = NULL,
  ylab = NULL,
  axis.title.size = 25,
  x.text.size = 25,
  y.text.size = 25,
  x.agl = 80,
  x.vjust = 0.6,
  fill = "#FF6666"
)
}
\arguments{
\item{df.res}{A \code{data.frame} of co-clustering optimization results.}

\item{para.na}{The targe parameter, which is a column name in \code{df.res}.}

\item{bar.width}{Width of a single bar.}

\item{thr}{A y-axis threshold, which will be used to draw a horizontal line.}

\item{title, title.size}{The plot title and its size.}

\item{xlab, ylab}{The x and y axis label respectively.}

\item{axis.title.size}{The size of x and y axis labels.}

\item{x.text.size, y.text.size}{The size of x and y axis text.}

\item{x.agl, x.vjust}{The angle and vertical position of x-axis text.}

\item{fill}{The color of bars.}
}
\value{
An object of ggplot.
}
\description{
Bar plots of co-clustering optimization results.
}
\examples{
set.seed(10)
df.res <- data.frame(dimred=sample(c('PCA', 'UMAP'), 50, replace=TRUE), cluster=sample(c('wt', 'fg', 'le'), 50, replace=TRUE))
opt_bar(df.res=df.res, para.na='cluster', ylab='Remaining outcomes')
}
\references{
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2016.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
