% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{read_cache}
\alias{read_cache}
\title{Read R Objects from Cache}
\usage{
read_cache(dir, name, info = FALSE)
}
\arguments{
\item{dir}{The directory path where cached data are located. It should be the path returned by \link{save_cache}.}

\item{name}{The name of the object to retrieve, which is one of the entries in the "rname" column returned by setting \code{info=TRUE}.}

\item{info}{Logical, TRUE or FALSE. If TRUE (default), the information of all tracked files in cache is returned in a table.}
}
\value{
An R object retrieved from the cache.
}
\description{
Read R Objects from Cache
}
\examples{
# Save the object "iris" in the default cache "~/.cache/shm".
cache.pa <- save_cache(dir=NULL, overwrite=TRUE, iris)
# Retrieve "iris".
iris1 <- read_cache(cache.pa, 'iris')
}
\references{
Lori Shepherd and Martin Morgan (2020). BiocFileCache: Manage Files Across Sessions. R package version 1.12.1.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
