% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/struct_class.R
\name{set_obj_show}
\alias{set_obj_show}
\title{a helper function to update the show method for a struct object}
\usage{
set_obj_show(class_name, extra_string, where = topenv(parent.frame()))
}
\arguments{
\item{class_name}{the name of the to update the method for}

\item{extra_string}{a function that returns an extra string using the input object as an input e.g. function(object){return = 'extra_string'}}

\item{where}{the environment to create the object in. default where = topenv(parent.frame())}
}
\value{
a method is created in the specified environment
}
\description{
a helper function to update the show method for a struct object
}
\examples{
# create an example object first
set_struct_obj(
class_name = 'add_two_inputs',
struct_obj = 'model',
params = c(input_1 = 'numeric', input_2 = 'numeric'),
outputs = c(result = 'numeric'),
prototype = list(
   input_1 = 0,
   input_2 = 0,
   name = 'Add two inputs',
   description = 'example class that adds two values together')
)

# now update the method
set_obj_show(
class_name = 'add_two_inputs',
extra_string = function(object) {return('The extra text')}
)

}
