% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align_prts.R
\name{align_prts}
\alias{align_prts}
\title{Get aligned amino acid sequences for gene transcripts}
\usage{
align_prts(gene_names, data_file, if_aa = FALSE, organism = "human", 
temp = FALSE)
}
\arguments{
\item{gene_names}{Vector containing names of genes of interest
(e.g. c(Crb1, Adgrl1))}

\item{data_file}{Path to the input file}

\item{if_aa}{Boolean value indicating if the input file contains
amino acid sequence. TRUE indicates that sequences are present and
FALSE indicates that only IDs are present.}

\item{organism}{String indicating if the transcripts are from a human or
a mouse}

\item{temp}{Boolean indicating if the fasta file should be saved to the
working directory or no}
}
\value{
Nothing is returned.
}
\description{
This function allows a user to specify genes of interest and subsequently
receive a pdf of all the corresponding aligned amino acid sequences in pdf
format.
}
\note{
Although the function returns nothing, it saves pdfs containing the
aligned sequences to the working directory under a file labeled with the
gene name.
}
\examples{
tmhmm_folder_name <- "~/TMHMM2.0c"
if (check_tmhmm_install(tmhmm_folder_name)) {
    align_prts(c("Crb1"), system.file("extdata", "crb1_example.csv",
        package = "surfaltr"
    ), TRUE, "mouse", TRUE)
}
}
