% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/timescape.R
\name{timescapeOutput}
\alias{timescapeOutput}
\alias{renderTimescape}
\alias{processUserData}
\alias{checkMinDims}
\alias{checkRequiredInputs}
\alias{checkAlpha}
\alias{checkClonalPrev}
\alias{checkTreeEdges}
\alias{checkGtypePositioning}
\alias{checkCloneColours}
\alias{checkPerts}
\alias{getMutationsData}
\alias{replaceSpaces}
\title{Widget output function for use in Shiny}
\usage{
timescapeOutput(outputId, width = "100\%", height = "400px")

renderTimescape(expr, env = parent.frame(), quoted = FALSE)

processUserData(clonal_prev, tree_edges, mutations, clone_colours, xaxis_title,
  yaxis_title, phylogeny_title, alpha, genotype_position, perturbations, sort,
  show_warnings, width, height)

checkMinDims(mutations, height, width)

checkRequiredInputs(clonal_prev, tree_edges)

checkAlpha(alpha)

checkClonalPrev(clonal_prev)

checkTreeEdges(tree_edges)

checkGtypePositioning(genotype_position)

checkCloneColours(clone_colours)

checkPerts(perturbations)

getMutationsData(mutations, tree_edges, clonal_prev)

replaceSpaces(clonal_prev, tree_edges, clone_colours, mutation_info, mutations,
  mutation_prevalences)
}
\arguments{
\item{outputId}{-- id of output}

\item{width}{-- width of output}

\item{height}{-- height of output}

\item{expr}{-- expression for Shiny}

\item{env}{-- environment for Shiny}

\item{quoted}{-- default is FALSE}

\item{clonal_prev}{-- data frame of Clonal prevalence. Note: timepoints will be alphanumerically sorted in the view.
Format: columns are (1) character() "timepoint" - time point
                    (2) character() "clone_id" - clone id
                    (3) numeric() "clonal_prev" - clonal prevalence.}

\item{tree_edges}{-- data frame of Tree edges of a rooted tree.
Format: columns are (1) character() "source" - source node id
                    (2) character() "target" - target node id.}

\item{mutations}{-- data frame (Optional) of Mutations occurring at each clone. Any additional field will be shown in the mutation table.
Format: columns are (1) character() "chrom" - chromosome number
                    (2) numeric() "coord" - coordinate of mutation on chromosome
                    (3) character() "clone_id" - clone id
                    (4) character() "timepoint" - time point
                    (5) numeric() "VAF" - variant allele frequency of the mutation in the corresponding timepoint.}

\item{clone_colours}{-- data frame (Optional) of Clone ids and their corresponding colours 
Format: columns are (1) character() "clone_id" - the clone ids
                    (2) character() "colour" - the corresponding Hex colour for each clone id.}

\item{xaxis_title}{-- String (Optional) of x-axis title. Default is "Time Point".}

\item{yaxis_title}{-- String (Optional) of y-axis title. Default is "Clonal Prevalence".}

\item{phylogeny_title}{-- String (Optional) of Legend phylogeny title. Default is "Clonal Phylogeny".}

\item{alpha}{-- Number (Optional) of Alpha value for sweeps, range [0, 100].}

\item{genotype_position}{-- String (Optional) of How to position the genotypes from ["centre", "stack", "space"] 
"centre" -- genotypes are centred with respect to their ancestors
"stack" -- genotypes are stacked such that no genotype is split at any time point
"space" -- genotypes are stacked but with a bit of spacing at the bottom}

\item{perturbations}{-- data frame (Optional) of any perturbations that occurred between two time points.
Format: columns are (1) character() "pert_name" - the perturbation name
                    (2) character() "prev_tp" - the time point (as labelled in clonal prevalence data) 
                                             BEFORE perturbation.}

\item{sort}{-- Boolean (Optional) of whether (TRUE) or not (FALSE) to vertically sort the genotypes by their emergence values (descending). 
Default is FALSE. 
Note that genotype sorting will always retain the phylogenetic hierarchy, and this parameter will only affect the ordering of siblings.}

\item{show_warnings}{-- Boolean (Optional) of  Whether or not to show any warnings. Default is TRUE.}

\item{mutation_info}{-- processed mutation_info}

\item{mutation_prevalences}{-- mutation_prevalences data from user}

\item{width}{-- Number (Optional) of width of the plot. Minimum width is 450.}

\item{height}{-- Number (Optional) of height of the plot. Minimum height with and without mutations is 500 and 260, respectively.}

\item{mutations}{-- mutations provided by user}

\item{height}{-- height provided by user}

\item{width}{-- width provided by user}

\item{clonal_prev}{-- clonal_prev provided by user}

\item{tree_edges}{-- tree_edges provided by user}

\item{alpha}{-- alpha provided by user}

\item{clonal_prev}{-- clonal prevalence provided by user}

\item{tree_edges}{-- tree edges provided by user}

\item{genotype_position}{-- genotype_position provided by user}

\item{clone_colours}{-- clone_colours provided by user}

\item{perturbations}{-- perturbations provided by user}

\item{mutations}{-- mutations data from user}

\item{tree_edges}{-- tree edges data from user}

\item{clonal_prev}{-- clonal prevalence data from user}

\item{clonal_prev}{-- clonal_prev data from user}

\item{tree_edges}{-- tree edges data from user}

\item{clone_colours}{-- clone_colours data from user}

\item{mutations}{-- mutations data from user}
}
\value{
None

None

Returns the ready list of user input data for htmlwidget

None

None

None

Clonal prevalence data after checkint it for column names and content types

Tree edges data after checkint it for column names and content types

None

None

Perturbations after checking them for content types and column names

List of mutation information and mutation prevalences

List of data frames with spaces replaced
}
\description{
Widget output function for use in Shiny

Widget render function for use in Shiny

Function to process the user data

Function to check minimum dimensions

Function to check required inputs are present

check alpha value input is correct

check clonal_prev parameter data

check tree_edges parameter data

check genotype_position parameter

check clone_colours parameter

check perturbations parameter

get mutation data

function to replace spaces with underscores in all data frames & keep maps of original names to space-replaced names
}
\examples{
timescapeOutput(1, '100\%', '300px')
timescapeOutput(1, '80\%', '300px')
checkMinDims(data.frame(chr = c("11"), coord = c(104043), VAF = c(0.1)), "700px", "700px")
checkRequiredInputs(data.frame(timepoint = c(rep("Diagnosis", 6), rep("Relapse", 1)), clone_id = c("1","2","3","4","5","6","7"), clonal_prev = c("0.1","0.22","0.08","0.53","0.009","0.061","1")), 
data.frame(source = c("1","1","2","2","5","6"), target=c("2","5","3","4","6","7")))
checkRequiredInputs(data.frame(timepoint = c(rep("Diagnosis", 6), rep("Relapse", 1)), clone_id = c("1","2","3","4","5","6","7"), clonal_prev = c("0.12","0.12","0.18","0.13","0.009","0.061","1")), 
data.frame(source = c("1","1","2","2","5","6"), target=c("2","5","3","4","6","7")))
checkAlpha(4)
checkAlpha(100)
checkClonalPrev(data.frame(timepoint=c(1), clone_id=c(2), clonal_prev=c(0.1)))
checkTreeEdges(data.frame(source = c("1","1","2","2","5","6"), target=c("2","5","3","4","6","7")))
checkGtypePositioning("centre")
checkCloneColours(data.frame(clone_id = c("1","2","3", "4"), colour = c("#beaed4", "#fdc086", "#beaed4", "#beaed4")))
checkPerts(data.frame(pert_name = c("New Drug"), prev_tp = c("Diagnosis")))
getMutationsData(data.frame(chrom = c("11"), coord = c(104043), VAF = c(0.1), clone_id=c(1), timepoint=c("Relapse")), 
data.frame(source = c("1","1","2","2","5","6"), target=c("2","5","3","4","6","7")), 
data.frame(timepoint = c(rep("Diagnosis", 6), rep("Relapse", 1)), clone_id = c("1","2","3","4","5","6","7"), clonal_prev = c("0.12","0.12","0.18","0.13","0.009","0.061","1")))
replaceSpaces(mutations = data.frame(chrom = c("11"), coord = c(104043), VAF = c(0.1), clone_id=c(1), timepoint=c("Relapse")), 
tree_edges = data.frame(source = c("1","1","2","2","5","6"), target=c("2","5","3","4","6","7")), 
clonal_prev = data.frame(timepoint = c(rep("Diagnosis", 6), rep("Relapse", 1)), clone_id = c("1","2","3","4","5","6","7"), clonal_prev = c("0.12","0.12","0.18","0.13","0.009","0.061","1")),
mutation_prevalences = list("X:6154028" = data.frame(timepoint = c("Diagnosis"), VAF = c(0.5557))), mutation_info=data.frame(clone_id=c(1)),
clone_colours = data.frame(clone_id = c("1","2","3", "4"), colour = c("#beaed4", "#fdc086", "#beaed4", "#beaed4")))
}
