% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusterStats.R
\name{classMeans}
\alias{classMeans}
\title{Get the mean of each cluster.}
\usage{
classMeans(droplets, classCol = "class")
}
\arguments{
\item{droplets}{A data frame of droplets with \code{Ch1.Amplitude} and
\code{Ch2.Amplitude} columns, as well as a classification column (see the
parameter \code{classCol}).}

\item{classCol}{The column (name or number) from \code{droplets}
representing the class.}
}
\value{
A list or data frame of means of each class.
}
\description{
After classifying droplets, we can compute the mean for each
class.
}
\examples{
## Get the means of the clusters.
aWell <- KRASdata[["E03"]]
aWell$Cluster <- relabelClasses(aWell, classCol="Cluster")
classMeans(aWell, classCol="Cluster")

## We repeat the above but with a sample with no "PP" cluster.
aWell <- KRASdata[["H04"]]
aWell$Cluster <- relabelClasses(aWell, classCol="Cluster")
classMeans(aWell, classCol="Cluster")

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
