% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readCSVDataFrame.R
\name{extractPlateName}
\alias{extractPlateName}
\title{Try to get plate name from a filename.}
\usage{
extractPlateName(filename)
}
\arguments{
\item{filename}{A character string corresponding to a filename with .csv
extension.}
}
\value{
A character string corresponding to the plate name. This is "" if
filename is not in a known format.
}
\description{
If the given filename is of the form "<PlateName>_<WellName>_Amplitude.csv",
where <WellName> is of the form A01, B01, etc., then this function can
extract the <PlateName> component. Otherwise, an empty string is returned.
}
\examples{
## Get the plate name (recognised format).
extractPlateName(c("Sample_Plate_Name_G02_Amplitude.csv"))

## Get the plate name (unrecognised format).
extractPlateName(c("Sample_G02.csv"))

}
\author{
Anthony Chiu, \email{anthony.chiu@cruk.manchester.ac.uk}
}
