% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diffVar.R
\docType{methods}
\name{deviation}
\alias{deviation}
\alias{deviation,MArrayLM-method}
\title{Deviation from expectation for each observation}
\usage{
deviation(fit, method = c("AD", "SQ"), scale = c("leverage", "none"))

\S4method{deviation}{MArrayLM}(fit, method = c("AD", "SQ"), scale = c("leverage", "none"))
}
\arguments{
\item{fit}{model fit from \code{dream()}}

\item{method}{transform the residuals using absolute deviation ("AD") or squared deviation ("SQ").}

\item{scale}{scale each observation by "leverage", or no scaling ("none")}
}
\value{
matrix of deviations from expection for each observation
}
\description{
Given a model fit for each features, residuals are computed and transformed based on an absolute value or squaring transform.
}
\examples{
# library(variancePartition)
library(edgeR)
data(varPartDEdata)

# filter genes by number of counts
isexpr <- rowSums(cpm(countMatrix) > 0.1) >= 5

# Standard usage of limma/voom
dge <- DGEList(countMatrix[isexpr, ])
dge <- calcNormFactors(dge)

# make this vignette faster by analyzing a subset of genes
dge <- dge[1:1000, ]

# regression formula
form <- ~Disease

# estimate precision weights
vobj <- voomWithDreamWeights(dge, form, metadata)

# fit dream model
fit <- dream(vobj, form, metadata)
fit <- eBayes(fit)

# Compute deviation from expection for each observation
# using model residuals
z <- deviation(fit)
z[1:4, 1:4]

}
\seealso{
\code{diffVar()}
}
