% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCorrMatrix.R
\name{plotCorrMatrix}
\alias{plotCorrMatrix}
\title{plotCorrMatrix}
\usage{
plotCorrMatrix(
  C,
  dendrogram = "both",
  sort = TRUE,
  margins = c(13, 13),
  key.xlab = "correlation",
  ...
)
}
\arguments{
\item{C}{correlation matrix: R or R^2 matrix}

\item{dendrogram}{character string indicating whether to draw 'both' or none'}

\item{sort}{sort rows and columns based on clustering}

\item{margins}{spacing of plot}

\item{key.xlab}{label of color gradient}

\item{...}{additional arguments to heatmap.2}
}
\value{
Image of correlation matrix
}
\description{
Plot correlation matrix
}
\details{
Plots image of correlation matrix using customized call to heatmap.2
}
\examples{

# simulate simple matrix of 10 variables
mat <- matrix(rnorm(1000), ncol = 10)

# compute correlation matrix
C <- cor(mat)

# plot correlations
plotCorrMatrix(C)

# plot squared correlations
plotCorrMatrix(C^2, dendrogram = "none")

}
