datacache <- new.env(hash=TRUE, parent=emptyenv())

hugene10sttranscriptcluster <- function() showQCData("hugene10sttranscriptcluster", datacache)
hugene10sttranscriptcluster_dbconn <- function() dbconn(datacache)
hugene10sttranscriptcluster_dbfile <- function() dbfile(datacache)
hugene10sttranscriptcluster_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
hugene10sttranscriptcluster_dbInfo <- function() dbInfo(datacache)

hugene10sttranscriptclusterORGANISM <- "Homo sapiens"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "hugene10sttranscriptcluster.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("HUMANCHIP_DB", "hugene10sttranscriptcluster", "chip hugene10sttranscriptcluster", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("hugene10sttranscriptcluster.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(hugene10sttranscriptcluster_dbconn())
}

