datacache <- new.env(hash=TRUE, parent=emptyenv())

org.EcK12.eg <- function() showQCData("org.EcK12.eg", datacache)
org.EcK12.eg_dbconn <- function() dbconn(datacache)
org.EcK12.eg_dbfile <- function() dbfile(datacache)
org.EcK12.eg_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
org.EcK12.eg_dbInfo <- function() dbInfo(datacache)

org.EcK12.egORGANISM <- "Escherichia coli"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "org.EcK12.eg.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"OrgDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("ECOLI_DB", "org.EcK12.eg", "E coli", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("org.EcK12.eg"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(org.EcK12.eg_dbconn())
}

