#' synaptome.data: AnnotationHub version of Synaptome.DB
#'
#' The package provides access to the public copy of the Synaptic
#' proteome database. It was designed as an accompaniment for
#' \code{\link[synaptome.db]{synaptome.db}} package. Database provides
#' information for specific genes and allows building the protein-protein
#' interaction graph for gene sets, synaptic compartments, and brain regions.
#' not intended for direct access. All querying and analysis is supposed to
#' be performed via \code{\link[synaptome.db]{synaptome.db}} functionality.
#'
#' @import AnnotationHub
#' @docType package
#' @name synaptome.data
#'
#' @references
#' Sorokina, O., Mclean, C., Croning, M.D.R. et al. (2021) "A unified resource
#' and configurable model of the synapse proteome and its role in disease."
#' \emph{Sci Rep} \strong{11}(1), 9967–9.
#' \url{https://doi.org/10.1038/s41598-021-88945-7}
"_PACKAGE"
