#' 
#' Clinical datasets from TCGA project
#'
#' Package provides clinical datasets from The Cancer Genome Atlas Project for all cohorts types from \url{http://gdac.broadinstitute.org/}.
#' Data were downloaded using \link{RTCGA-package} and contain snapshots for the date: \code{2015-11-01}. The process is described here: \url{http://rtcga.github.io/RTCGA/}.
#' Use cases, examples and information about datasets in \pkg{RTCGA.data} family can be found here: \code{browseVignettes("RTCGA")}. Clinical data format is explained here \url{https://wiki.nci.nih.gov/display/TCGA/Clinical+Data+Overview}.
#' 
#' @details \code{browseVignettes("RTCGA")}
#' 
#' @examples
#' 
#' \dontrun{
#' browseVignettes("RTCGA")
#' }
#'
#' 
#' @return Data frames with clinical data.
#' 
#' @import RTCGA
#' @format NULL
#' @source \url{http://gdac.broadinstitute.org/}
#' 
#' @name clinical
#' @rdname clinical
#' @aliases ACC.clinical,BLCA.clinical,BRCA.clinical,CESC.clinical,CHOL.clinical,COAD.clinical,COADREAD.clinical,DLBC.clinical,ESCA.clinical,FPPP.clinical,GBM.clinical,GBMLGG.clinical,HNSC.clinical,KICH.clinical,KIPAN.clinical,KIRC.clinical,KIRP.clinical,LAML.clinical,LGG.clinical,LIHC.clinical,LUAD.clinical,LUSC.clinical,MESO.clinical,OV.clinical,PAAD.clinical,PCPG.clinical,PRAD.clinical,READ.clinical,SARC.clinical,SKCM.clinical,STAD.clinical,STES.clinical,TGCT.clinical,THCA.clinical,THYM.clinical,UCEC.clinical,UCS.clinical,UVM.clinical
#'
"ACC.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#'
"BLCA.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"BRCA.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"CESC.clinical"    
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"CHOL.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"COAD.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"COADREAD.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"DLBC.clinical"    
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"ESCA.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"FPPP.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"GBM.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"GBMLGG.clinical"  
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"HNSC.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"KICH.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"KIPAN.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"KIRC.clinical"    
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"KIRP.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"LAML.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"LGG.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"LIHC.clinical"    
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"LUAD.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"LUSC.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"MESO.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"OV.clinical"      
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"PAAD.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"PCPG.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"PRAD.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"READ.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"SARC.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"SKCM.clinical"    
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"STAD.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"STES.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"TGCT.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"THCA.clinical"    
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"THYM.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"UCEC.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"UCS.clinical"
#' @name clinical
#' @rdname clinical
#' @format NULL
#' 
"UVM.clinical"