% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easierData_retrieval.R
\name{get_opt_xtrain_stats}
\alias{get_opt_xtrain_stats}
\title{Get training set cancer-specific features mean and standard deviation}
\usage{
get_opt_xtrain_stats()
}
\value{
A list containing for each cancer type and quantitative
descriptor, a matrix with feature mean and sd values across the
100 cross-validation runs. The cancer types, for which cancer-specific
features mean and sd is available, are: "BLCA", "BRCA", "CESC",
"CRC", "GBM", "HNSC", "KIRC", "KIRP", "LIHC", "LUAD", "LUSC", "NSCLC",
"OV", "PAAD", "PRAD", "SKCM", "STAD", "THCA" and "UCEC".
}
\description{
Obtain the cancer-specific features mean and standard deviation (sd)
of the training set used in Lapuente-Santana et al. (2021) for model
training by  using randomized cross-validation repeated 100 times.
It is required for normalization of the test set.
}
\examples{
if (interactive()) {
    opt_xtrain_stats <- get_opt_xtrain_stats()
}
}
\references{
Óscar Lapuente-Santana, Maisa van Genderen, Peter A. J. Hilbers,
Francesca Finotello, and Federica Eduati. 2021. Interpretable Systems
Biomarkers Predict Response to Immune-Checkpoint Inhibitors.
Patterns, 100293. https://doi.org/10.1016/j.patter.2021.100293.
}
