\name{16SrRNA}
\alias{16SrRNA}
\alias{16S}
\alias{fungalits_unite}
\alias{fungalits_warcup}
\alias{fungallsu}
\title{
RDP Classifier Model for RDP 16S rRNA Trainingset No 19
}
\description{
Model data for he RDP Classifier 2.14 released in August 2023. The classifier 
is trained with the latest bacterial and archaeal taxonomy training set No. 19. 
See Wang and Cole (2024).

16SrRNA is the default model data used by the classifier in package `rRDP`.
}
\details{
\code{rdp()} creates a default classifier using this data set.

The model data 
is stored in \code{system.file("extdata", package="rRDPData")} and
consists of several files in proprietary format used by the RDP software. 
Since RDP is a naive Bayes classifier the data mainly contain conditional 
word (8-mer) probabilities.
}
%\value{
%}
\references{
RDP Classifier \url{http://sourceforge.net/projects/rdp-classifier/}

Qiong W. and Cole J.R. Updated RDP taxonomy and RDP Classifier for more accurate taxonomic classification,
Microbial Ecology, Announcement, 4 March 2024. \doi{https://doi.org/10.1128/mra.01063-23}
}
\examples{


### Use the RDP with the default classifier model data
cl_16S <- rdp()
cl_16S

seq <- readRNAStringSet(system.file("examples/RNA_example.fasta",
	package="rRDP"))

## shorten names
names(seq) <-  sapply(strsplit(names(seq), " "), "[", 1)
seq

## use RDP for classification 
pred <- predict(cl_16S, seq)
pred
  
attr(pred, "confidence")

### Query a different model

## List all available models
dir(system.file("extdata", package="rRDPData"))

cl_fungus <- rdp(system.file("extdata", "fungallsu", package="rRDPData"))
cl_fungus

pred <- predict(cl_fungus, seq)
pred

attr(pred, "confidence")
}
\keyword{model}
