% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_clusters_to_enrichment.R
\name{main_clusters_to_enrichment}
\alias{main_clusters_to_enrichment}
\title{Perform enrichment analysis on multiple lists of genes}
\usage{
main_clusters_to_enrichment(
  input_file = NULL,
  gene_attribute_file = NULL,
  org_db = NULL,
  gene_keytype = "ENTREZID",
  temp_file = "enr_tmp.RData",
  force = FALSE,
  all_funsys = c("BP", "MF", "CC"),
  task_size = 1,
  current_organism_info = NULL,
  workers = 1,
  pvalcutoff = 0.1,
  qvalcutoff = 0.2,
  all_custom_gmt = NULL,
  kegg_data_file = NULL,
  universe = NULL
)
}
\arguments{
\item{input_file}{input file path. File must contain 1 cluster per line clusterA ..tab.. gene1,gene2}

\item{gene_attribute_file}{file to map genes to attributes e.g. fold change}

\item{org_db}{org_db object}

\item{gene_keytype}{ID used in the input file}

\item{temp_file}{enrichments will be read from this file if it exists, written to it if it doesnt}

\item{force}{if true, to run enrichments even if the temp_file exists}

\item{all_funsys}{list of GOs/dbs to use for enrichment analysis}

\item{task_size}{number of elements per packages used}

\item{current_organism_info}{organism info from text table,}

\item{workers}{cores to be used if parallel features are going to be used}

\item{pvalcutoff}{adjusted p-value threshold to use for clusterProfiler,}

\item{qvalcutoff}{q-value threshold to use for clusterProfiler,}

\item{all_custom_gmt}{list of custom annotation sets}

\item{kegg_data_file}{if KEGG included in enrich_dbs path needs}

\item{universe}{background of genes to use as universe}
}
\description{
Perform enrichment analysis on multiple lists of genes
}
