% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_degsynth.R
\name{degsynth}
\alias{degsynth}
\title{Main function to generate synthetic data using an specific exponential
distribution for logFC}
\usage{
degsynth(
  outfile = NULL,
  inputfile = NULL,
  replicates = 3,
  ngenes = 20000,
  DEGs_proportion = 0.2,
  FC_min = 1.3,
  FC_max = 3,
  P_up = 1,
  group = NULL
)
}
\arguments{
\item{outfile}{output file}

\item{inputfile}{input file}

\item{replicates}{number of replicates}

\item{ngenes}{number of genes}

\item{DEGs_proportion}{numeric (0,1) proportion of DEG genes to be simulated}

\item{FC_min}{minimum Fold-Change}

\item{FC_max}{maximum Fold-Change}

\item{P_up}{proportion og up-regulated genes}

\item{group}{optional group identifiers seprated by commas}
}
\value{
synthetic data generated
}
\description{
Main function to generate synthetic data using an specific exponential
distribution for logFC
}
\examples{
synthetic_dataset <- degsynth()
# Returns simulated count dataset and indication of which are DE/not DE
}
\keyword{synthetic}
