% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PAC_jitter.R
\name{PAC_jitter}
\alias{PAC_jitter}
\title{Plots jitter plot from PAC object}
\usage{
PAC_jitter(
  PAC,
  summary_target = NULL,
  anno_target = NULL,
  style = "jitter",
  limits = NULL,
  ypos_n = NULL,
  colors = NULL,
  box = TRUE
)
}
\arguments{
\item{PAC}{PAC-object containing Anno and a summary list-folder with
summarized dataframe(s) for example generated by PAC_summary. The function
can also be applied on a dataframe containing a column with annotation
groupings (e.g. biotype) and a column with summarized data (e.g. log2 fold
changes). Rows should be unique sequences as the rownames of a PAC summary
object.}

\item{summary_target}{List with: 1st object being a character vector of the
target dataframe in summary and 2nd object being a character vector of the
target column(s) in that dataframe. In case of input being a dataframe,
summary_target can be a character vector indicating the column with the
summarized data.}

\item{anno_target}{Character vector with the name of the target column in
Anno or the name of the annotation column in case of input being a
dataframe.}

\item{style}{Character. If style="jitter" (default) the jitter-plots will be
returned. If style="violin", a violin-plot will instead the returned.}

\item{limits}{Integer vector with the y-limits to be parsed to ggplot2.}

\item{ypos_n}{Integer setting the y position of the n counts to be parsed to
ggplot2.}

\item{colors}{Character vector with color codes to be parsed to ggplot2.}

\item{box}{Logical whether a boxplot should be plotted or not (default=TRUE)}
}
\value{
A plot-list object with jitter plots generated by ggplot2.
}
\description{
\code{PAC_jitter} Plots a jitter plot using the information in the Anno and
Counts tables in a PAC object.
}
\details{
Given a PAC object with grouped summaries, the function will use column(s) in
the Anno object to group assigned summary columns (summary_target) and plot a 
jitter plot.
}
\examples{

## Prepare
load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))
pac <- PAC_norm(pac, norm="cpm")

pac <- PAC_summary(PAC=pac, norm = "cpm", type = "log2FC", 
                   pheno_target=list("stage"))
pac <- PAC_summary(PAC=pac, norm = "cpm", type = "percentgrand", 
                   pheno_target=list("stage"))

## Jitter plots
plots_FC <- PAC_jitter(pac, summary_target=list("Log2FC_stage"), 
                       anno_target=list("Biotypes_mis0"))
plots_FCgrand <- PAC_jitter(pac, summary_target=list("percGrand_stage"), 
                            anno_target=list("Biotypes_mis0"))

cowplot::plot_grid(plotlist=plots_FC, nrow = 3, ncol = 1)
cowplot::plot_grid(plotlist=plots_FCgrand, nrow = 3, ncol = 1) 

## Violin plots instead
plots_FC <- PAC_jitter(pac, style="violin", 
                       summary_target=list("Log2FC_stage"), 
                       anno_target=list("Biotypes_mis0"))
plots_FCgrand <- PAC_jitter(pac, style="violin", 
                            summary_target=list("percGrand_stage"), 
                            anno_target=list("Biotypes_mis0"))

cowplot::plot_grid(plotlist=plots_FC, nrow = 3, ncol = 1)
cowplot::plot_grid(plotlist=plots_FCgrand, nrow = 3, ncol = 1)  


## Violin with changed biotype order
new_order  <- as.character(unique(anno(pac)$Biotypes_mis0))[c(2,4,3,6,7,5,1)]
plots_FC <- PAC_jitter(pac, style="violin", 
                       summary_target=list("Log2FC_stage"), 
                       anno_target=list("Biotypes_mis0", new_order))
cowplot::plot_grid(plotlist=plots_FC, nrow = 3, ncol = 1)


}
\seealso{
\url{https://github.com/OestLab/seqpac} for updates on the current
  package.

Other PAC analysis: 
\code{\link{PAC_covplot}()},
\code{\link{PAC_deseq}()},
\code{\link{PAC_filter}()},
\code{\link{PAC_filtsep}()},
\code{\link{PAC_gtf}()},
\code{\link{PAC_mapper}()},
\code{\link{PAC_nbias}()},
\code{\link{PAC_norm}()},
\code{\link{PAC_pca}()},
\code{\link{PAC_pie}()},
\code{\link{PAC_saturation}()},
\code{\link{PAC_sizedist}()},
\code{\link{PAC_stackbar}()},
\code{\link{PAC_summary}()},
\code{\link{PAC_trna}()},
\code{\link{as.PAC}()},
\code{\link{filtsep_bin}()},
\code{\link{map_rangetype}()},
\code{\link{tRNA_class}()}
}
\concept{PAC analysis}
