### R code from vignette source 'IMAS.Rnw'

###################################################
### code chunk number 1: style
###################################################
BiocStyle::latex(use.unsrturl=FALSE)


###################################################
### code chunk number 2: Installation of IMAS (eval = FALSE)
###################################################
## if (!requireNamespace("BiocManager", quietly=TRUE))
##     install.packages("BiocManager")
## BiocManager::install("IMAS")


###################################################
### code chunk number 3: loading Names package
###################################################
library(IMAS)


###################################################
### code chunk number 4: loading the paths of the expression data
###################################################
data(bamfilestest)
ext.dir <- system.file("extdata", package="IMAS")
samplebamfiles[,"path"] <- 
    paste(ext.dir,"/samplebam/",samplebamfiles[,"path"],".bam",sep="")


###################################################
### code chunk number 5: loading group information
###################################################
data(sampleGroups)


###################################################
### code chunk number 6: loading the SNP data
###################################################
data(samplesnp)


###################################################
### code chunk number 7: loading the SNP position data
###################################################
data(samplesnplocus)


###################################################
### code chunk number 8: loading methylation expression data
###################################################
data(samplemethyl)


###################################################
### code chunk number 9: loading methylation position data
###################################################
data(samplemethyllocus)


###################################################
### code chunk number 10: loading clinical information data
###################################################
data(sampleclinical)


###################################################
### code chunk number 11: loading the txdb data
###################################################
sampledb <- list.files(ext.dir,pattern="DB",full.names=TRUE)
transdb <- loadDb(sampledb)
transdb


###################################################
### code chunk number 12: Splicingfinder function
###################################################
ASdb <- Splicingfinder(GTFdb=transdb,calGene="ENSG00000082175",Ncor=1)
ASdb <- ExonsCluster(ASdb,transdb)
ASdb
head(slot(ASdb,"SplicingModel")$"ES")


###################################################
### code chunk number 13: RatioFromReads function
###################################################
ASdb <- RatioFromReads(ASdb=ASdb,samplebamfiles,readsInfo="paired",
    readLen=50,inserSize=40,minr=3,CalIndex="ES3",Ncor=1)
ASdb

head(rbind(slot(ASdb,"Ratio")$"ES"[,1:20]))


###################################################
### code chunk number 14: CompGroupAlt function
###################################################
ASdb <- CompGroupAlt(ASdb=ASdb,GroupSam=GroupSam,Ncor=1,CalIndex="ES3")
ASdb

head(slot(ASdb,"GroupDiff")$"ES")


###################################################
### code chunk number 15: sQTLsFinder function
###################################################
ASdb <- sQTLsFinder(ASdb=ASdb,Total.snpdata=samplesnp,Total.snplocus=samplesnplocus,
    GroupSam=NULL,Ncor=1,CalIndex="ES3",method="lm")
ASdb

head(slot(ASdb,"sQTLs")$"ES")


###################################################
### code chunk number 16: MEsQTLFinder function
###################################################
ASdb <- MEsQTLFinder(ASdb=ASdb,Total.Medata=sampleMedata,Total.Melocus=sampleMelocus,
    GroupSam=GroupSam,Ncor=1,CalIndex="ES3")
ASdb

head(slot(ASdb,"Me.sQTLs")$"ES")


###################################################
### code chunk number 17: clinical analysis function
###################################################
ASdb <- ClinicAnalysis(ASdb=ASdb,ClinicalInfo=Clinical.data,Ncor=1,CalIndex="ES3")
ASdb

head(slot(ASdb,"Clinical")$"ES")


###################################################
### code chunk number 18: visualization function
###################################################
exon.range <- exonsBy(transdb,by="tx")
select.cns <- c("TXCHROM","TXNAME","GENEID","TXSTART","TXEND","TXSTRAND")
txTable <- select(transdb, keys=names(exon.range),columns=select.cns,keytype="TXID")
ASvisualization(ASdb,CalIndex="ES3",txTable,exon.range,samplesnp,samplesnplocus,
                sampleMedata,sampleMelocus,GroupSam,Clinical.data,out.dir=tempdir())


###################################################
### code chunk number 19: sessionInfo
###################################################
sessionInfo()


