## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(
    comment = "",
    warning = FALSE,
    message = FALSE,
    cache = FALSE
)

## ----installation, eval=FALSE, include=FALSE----------------------------------
#  if (!requireNamespace("BiocManager", quietly = TRUE)) {
#      install.packages("BiocManager")
#  }
#  BiocManager::install("UPDhmm")
#  BiocManager::install("regioneR")
#  BiocManager::install("karyoploteR")

## ----loading libraries, message = FALSE---------------------------------------
library(UPDhmm)
library(dplyr)

## ----read Vcf,echo=TRUE-------------------------------------------------------
library(UPDhmm)
library(VariantAnnotation)
file <- system.file(package = "UPDhmm", "extdata", "test_het_mat.vcf.gz")
vcf <- readVcf(file)
processedVcf <- vcfCheck(
    vcf,
    proband = "NA19675", mother = "NA19678", father = "NA19679"
)

## ----calculateEvents function, echo=TRUE--------------------------------------
updEvents <- calculateEvents(largeCollapsedVcf = processedVcf)
head(updEvents)

## ----echo=TRUE----------------------------------------------------------------
library(karyoploteR)
library(regioneR)
plotUPDKp <- function(updEvents) {
    updEvents$seqnames <- paste0("chr", updEvents$seqnames)
    het_fat <- toGRanges(subset(
        updEvents,
        group == "het_fat"
    )[, c("seqnames", "start", "end")])
    het_mat <- toGRanges(subset(
        updEvents,
        group == "het_mat"
    )[, c("seqnames", "start", "end")])
    iso_fat <- toGRanges(subset(
        updEvents,
        group == "iso_fat"
    )[, c("seqnames", "start", "end")])
    iso_mat <- toGRanges(subset(
        updEvents,
        group == "iso_mat"
    )[, c("seqnames", "start", "end")])

    kp <- plotKaryotype(genome = "hg19")
    kpPlotRegions(kp, het_fat, col = "#AAF593")
    kpPlotRegions(kp, het_mat, col = "#FFB6C1")
    kpPlotRegions(kp, iso_fat, col = "#A6E5FC")
    kpPlotRegions(kp, iso_mat, col = "#E9B864")

    colors <- c("#AAF593", "#FFB6C1", "#A6E5FC", "#E9B864")
    legend("topright",
        legend = c("Het_Fat", "Het_Mat", "Iso_Fat", "Iso_Mat"),
        fill = colors
    )
}

plotUPDKp(updEvents)

## -----------------------------------------------------------------------------
sessionInfo()

