## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(cache = TRUE)

## ----eval=FALSE---------------------------------------------------------------
#  if (!require("BiocManager", quietly = TRUE))
#      install.packages("BiocManager")
#  BiocManager::install("VisiumIO")

## ----include=TRUE,results="hide",message=FALSE,warning=FALSE------------------
library(VisiumIO)

## ----eval=FALSE---------------------------------------------------------------
#  TENxVisium(
#      resources = "path/to/10x/visium/file.tar.gz",
#      spatialResource = "path/to/10x/visium/spatial/file.spatial.tar.gz",
#      spacerangerOut = "path/to/10x/visium/sample/folder",
#      sample_id = "sample01",
#      images = c("lowres", "hires", "detected", "aligned"),
#      jsonFile = "scalefactors_json.json",
#      tissuePattern = "tissue_positions.*\\.csv",
#      spatialCoordsNames = c("pxl_col_in_fullres", "pxl_row_in_fullres")
#  )

## -----------------------------------------------------------------------------
sample_dir <- system.file(
    file.path("extdata", "10xVisium", "section1"),
    package = "SpatialExperiment"
)

vis <- TENxVisium(
    spacerangerOut = sample_dir, processing = "raw", images = "lowres"
)
vis

## -----------------------------------------------------------------------------
import(vis)

## ----eval=FALSE---------------------------------------------------------------
#  TENxVisiumList(
#      sampleFolders = "path/to/10x/visium/sample/folder",
#      sample_ids = c("sample01", "sample02"),
#      ...
#  )

## -----------------------------------------------------------------------------
sample_dirs <- list.dirs(
    system.file(
        file.path("extdata", "10xVisium"), package = "SpatialExperiment"
    ),
    recursive = FALSE, full.names = TRUE
)
    
vlist <- TENxVisiumList(
    sampleFolders = sample_dirs,
    sample_ids = basename(sample_dirs),
    processing = "raw",
    image = "lowres"
)
vlist

## -----------------------------------------------------------------------------
import(vlist)

## -----------------------------------------------------------------------------
sessionInfo()

