% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnVILBrowse.R
\name{AnVILBrowse}
\alias{AnVILBrowse}
\title{Search AnVIL workspaces using keywords}
\usage{
AnVILBrowse(
  keyword,
  searchFrom = "all",
  returnFrom = NULL,
  metaTables = "default",
  minAge = 0,
  maxAge = 130,
  minCount = 0,
  workspaceTable = NULL,
  workflowTable = NULL,
  dataTable = NULL
)
}
\arguments{
\item{keyword}{A character(1). Regular expression is accepted. For example,
you can search multiple keywords separated by the vertical bar ("\code{|}").}

\item{searchFrom}{Under the default (\code{all}), all the workspaces
containing keywords in their workspace/workflow/data will be returned.
The other available options are \code{workspace}, \code{workflow}, and
\code{data}.}

\item{returnFrom}{Under the default (\code{NULL}), the same data type
as for \code{searchFrom} will be used, while \code{searchFrom = "all"}
returns workspaces.}

\item{metaTables}{Under the default (\code{default}), all the publicly
accessible AnVIL workspaces will be subjected for search. If you want
to search in all the workspaces you have access to, set this argument as
\code{custom}, and provide the inputs for \code{workspaceTable},
\code{workflowTable}, and \code{dataTable} arguments.}

\item{minAge}{A number. Any data with a maximum participant age lower than
this parameter will be excluded from the output. Under the default
(\code{0}), no data entries will be removed due to the maximum participant
age. Data entries with no maximum participant age listed will not be removed
by this argument.}

\item{maxAge}{A number. Any data with a minimum participant age higher than
this parameter will be excluded from the output. Under the default
(\code{130}), no data entries will be removed due to the minimum participant
age. Data entries with no minimum participant age listed will not be removed
by this argument.}

\item{minCount}{A number. Any data with a participant count fewer than this
parameter will be excluded from the output. Under the default (\code{0}), no
data entries will be removed due to participant count. Data entries with no
participant count listed will not be removed by this argument.}

\item{workspaceTable}{A data frame. This argument is counted only when
\code{metaTables = "custom"}. Provide the output from the
\code{getWorkspaces} function, to search in all the workspaces
you have access to.}

\item{workflowTable}{A data frame. This argument is counted only when
\code{metaTables = "custom"}. Provide the output from the
\code{getWorkflows} function, to search in all the workflows
you have access to.}

\item{dataTable}{A data frame. This argument is counted only when
\code{metaTables = "custom"}. Provide the output from the \code{getData}
function, to search in all the AnVIL data you have access to.}
}
\value{
A data frame of AnVIL resources containing keywords. Depending on
the \code{returnFrom} argument, it can be workspaces, workflows, or data.
Under the default \code{returnFrom = NULL}, it returns the same data type
as specified in \code{searchFrom} or workspace for \code{searchFrom = "all"}.
}
\description{
Search AnVIL workspaces using keywords
}
\examples{
AnVILBrowse("malaria")
AnVILBrowse("resistance")
AnVILBrowse("resistance", searchFrom = "workflow")

}
