% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloneWorkspace.R
\name{cloneWorkspace}
\alias{cloneWorkspace}
\title{Clone template workspace}
\usage{
cloneWorkspace(
  workspaceName,
  templateName = "",
  analysis = NULL,
  accountEmail = gcloud_account(),
  billingProjectName = gcloud_project()
)
}
\arguments{
\item{workspaceName}{Name of the workspace you are creating}

\item{templateName}{Character(1). Name of the template workspace name you
want to clone. You can provide \code{name} or \code{namespace/name}.}

\item{analysis}{Character(1). Name of the analysis you want to clone
it's workspace. The list of available analyses can be found using
\code{\link{availableAnalysis}}.}

\item{accountEmail}{Character(1). Email linked to Terra account}

\item{billingProjectName}{Character(1). Name of the billing project}
}
\value{
Name of the cloned workspace
}
\description{
This function makes your own copy of the existing workspace, selected
through \code{templateName} or \code{analysis}. Your copied/cloned
workspace name will be \code{workspaceName} and any computing cost will
be charaged to the billing linked to your \code{billingProjectName}.
You should provide at least one argument \code{templateName} or
\code{analysis}.
}
\examples{
library(AnVIL)
if (gcloud_exists() && nzchar(avworkspace_name())) {
cloneWorkspace(workspaceName = "salmon",
               templateName = "Bioconductor-Workflow-DESeq2")
}
 
}
