% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findInputName.R
\name{findInputName}
\alias{findInputName}
\title{Find the root entity name}
\usage{
findInputName(workspaceName, rootEntity = "", nameOnly = TRUE)
}
\arguments{
\item{workspaceName}{Name of the workspace}

\item{rootEntity}{A character. Type of root entity for Terra's data model.
For example, \code{participant}, \code{participant_set}, \code{sample}, etc.}

\item{nameOnly}{Under the default (\code{TRUE}), only the names of a given
root entity type will be returned.}
}
\value{
A character vector of input names under the given root entity.
}
\description{
Find the root entity name
}
\examples{
library(AnVIL)
if (gcloud_exists() && nzchar(avworkspace_name())) {
.findInputName(
workspaceName = "Bioconductor-Workflow-DESeq2",
rootEntity = "participant_set")
}

}
