% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runWorkflow.R
\name{runWorkflow}
\alias{runWorkflow}
\title{Launch Terra workflow}
\usage{
runWorkflow(
  workspaceName,
  config,
  workflowName = NULL,
  useCallCache = TRUE,
  inputName = NULL
)
}
\arguments{
\item{workspaceName}{Name of the workspace that contains the workflow(s) you
want to launch.}

\item{config}{Workflow configuration. Output from the
\code{\link{getWorkflowConfig}} function.}

\item{workflowName}{Name of the workflow to run. If this input is not
provided but there is only a single workflow available, the function
will automatically use the only workflow.}

\item{useCallCache}{A logical. Under the default condition (\code{TRUE}),
call cache will be used.}

\item{inputName}{Name of you input entity. If the workflow is using Terra's
data model, this is required. The available entities can be found using the
\code{findInputName} function.}
}
\value{
This function will print out whether the call for workflow
launching was successful or not.
}
\description{
Launch Terra workflow
}
\examples{
library(AnVIL)
if (gcloud_exists() && nzchar(avworkspace_name())) {
if ("salmon" \%in\% avworkspaces()$name)
runWorkflow(workspaceName = "salmon")
}

}
