% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BG2.R
\name{BG2}
\alias{BG2}
\title{Performs BG2 as described in the manuscript, Xu, Williams, and Ferreira BG2: Bayesian variable selection in generalized linear mixed models with non-local priors for non-Gaussian GWAS data, Bioinformatics, Submitted.}
\usage{
BG2(
  Y,
  SNPs,
  FDR_Nominal = 0.05,
  Fixed = NULL,
  family = c("poisson", "bernoulli"),
  Covariance,
  Z = NULL,
  replicates = NULL,
  Tau = "uniform",
  maxiterations = 4000,
  runs_til_stop = 400
)
}
\arguments{
\item{Y}{The observed phenotypes, count or binary.}

\item{SNPs}{The SNP matrix, where each column represents a single SNP encoded as the numeric coding 0, 1, 2. This is entered as a matrix object.}

\item{FDR_Nominal}{The nominal false discovery rate for which SNPs are selected from in the screening step.}

\item{Fixed}{A matrix of fixed covariates to control for. Do not include the intercept. The value is defaulted at NULL implying no fixed covariates.}

\item{family}{Specify if the response is count ("poisson") or binary ("bernoulli").}

\item{Covariance}{A list of covariance matrices that are the covariance matrices of the random effects. This matches the list of design matrices in Z.}

\item{Z}{A list of matrices specifying the design matrix of each random effect of interest.}

\item{replicates}{If family = "poisson", the replicates of each ecotype, can be a vector or a number if the number of replicates is the same for each ecotype. If family = "binomial", replicates = NULL.}

\item{Tau}{Specifying either a fixed value for the dispersion parameter of the nonlocal prior (0.022 and 0.348 are used in the paper). Or specify a prior for tau, either uniform or Inverse Gamma centered at ...}

\item{maxiterations}{The maximum iterations the genetic algorithm in the model selection step iterates for.
Defaulted at 400 which is the value used in the BICOSS paper simulation studies.}

\item{runs_til_stop}{The number of iterations at the same best model before the genetic algorithm in the model selection step converges.
Defaulted at 40 which is the value used in the BICOSS paper simulation studies.}
}
\value{
The column indices of SNPs that were in the best model identified by BICOSS.
}
\description{
Performs BG2 as described in the manuscript ...
}
\examples{
library(BG2)
data("Y_poisson");data("SNPs");data("kinship")
n <- length(Y_poisson)
covariance <- list()
covariance[[1]] <- kinship
covariance[[2]] <- diag(1, nrow = n, ncol = n)

set.seed(1330)
output_poisson <- BG2(Y=Y_poisson, SNPs=SNPs, Fixed = NULL,
                   Covariance=covariance, Z=NULL, family="poisson",
                   replicates=4, Tau="uniform",FDR_Nominal = 0.05,
                   maxiterations = 4000, runs_til_stop = 400)

}
