% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialFunctions.R
\name{calculateBsFoldChange}
\alias{calculateBsFoldChange}
\title{Compute fold-changes per binding site}
\usage{
calculateBsFoldChange(
  object,
  fitType = "local",
  sfType = "ratio",
  minReplicatesForReplace = 10,
  independentFiltering = TRUE,
  alpha = 0.05,
  pAdjustMethod = "BH",
  minmu = 0.5,
  filterFun = NULL,
  use.lfc.shrinkage = FALSE,
  type = c("ashr", "apeglm", "normal"),
  svalue = FALSE,
  apeAdapt = TRUE,
  apeMethod = "nbinomCR",
  match.geneID = "geneID",
  quiet = TRUE,
  veryQuiet = FALSE,
  replaceNegative = FALSE,
  removeNA = FALSE
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{fitType}{either "parametric", "local", "mean", or "glmGamPoi" for the
type of fitting of dispersions to the mean intensity.
See \code{\link[DESeq2]{DESeq}} for more details.}

\item{sfType}{either "ratio", "poscounts", or "iterate" for the type of size
factor estimation. See \code{\link[DESeq2]{DESeq}} for more details.}

\item{minReplicatesForReplace}{the minimum number of replicates required in
order to use replaceOutliers on a sample. See \code{\link[DESeq2]{DESeq}} for
more details.}

\item{independentFiltering}{logical, whether independent filtering should be
applied automatically. See \code{\link[DESeq2]{results}} for more details.}

\item{alpha}{the significance cutoff used for optimizing the independent
filtering. See \code{\link[DESeq2]{results}} for more details.}

\item{pAdjustMethod}{he method to use for adjusting p-values. See
\code{\link[DESeq2]{results}} for more details.}

\item{minmu}{lower bound on the estimated count. See
\code{\link[DESeq2]{results}} for more details.}

\item{filterFun}{an optional custom function for performing independent
filtering and p-value adjustment. See \code{\link[DESeq2]{results}} for more
details.}

\item{use.lfc.shrinkage}{logical; whether to compute shrunken log2 fold
changes for the DESeq results. See \code{\link[DESeq2]{lfcShrink}} for more
details.}

\item{type}{if 'ashr', 'apeglml' or 'normal' should be used for fold change
shrinkage. See \code{\link[DESeq2]{lfcShrink}} for more details.}

\item{svalue}{logical, should p-values and adjusted p-values be replaced with
s-values when using apeglm or ashr. See \code{\link[DESeq2]{lfcShrink}}
for more details.}

\item{apeAdapt}{logical, should apeglm use the MLE estimates of LFC to adapt
the prior. See \code{\link[DESeq2]{lfcShrink}} for more details.}

\item{apeMethod}{what method to run apeglm, which can differ in terms of
speed. See \code{\link[DESeq2]{lfcShrink}} for more details.}

\item{match.geneID}{character; the name of the column with the gene ID
in the binding sites meta columns used for matching binding sites to genes}

\item{quiet}{logical; whether to print messages or not}

\item{veryQuiet}{logical; whether to print messages or not}

\item{replaceNegative}{logical; force negative counts to be replaces by 0.
Be careful when using this, having negative counts can point towards problems
with the gene annotation in use.}

\item{removeNA}{logical; force binding sites with any NA value to be removed.
Be careful when using this, having negative counts can point towards problems
with the gene annotation in use.}
}
\value{
a \code{\link{BSFDataSet}} object, with results from the
\code{\link[DESeq2]{DESeq}} analysis added to the meta columns of the
binding site ranges.
}
\description{
Given count data for binding sites and background regions this function will
compute fold-changes between two condition for each binding site. Computation
is based on \code{\link[DESeq2]{DESeq}} using the Likelihood ratio test to
disentangle transcription level changes from binding site level changes.
}
\details{
Fold-changes per binding sites are corrected for transcript level changes.
Essentially, background counts are used to model transcript level changes,
which are then used to compute fold-changes per binding site, which are
corrected for the observed transcript level changes. This is done by using a
Likelihood ratio test comparing the full model
(~condition + type + condition:type) to the reduced model (~condition + type).

Fold-changes for the transcript level changes are modeled explicitly in a
second round of the \code{\link[DESeq2]{DESeq}} workflow, using the default
Wald test to compare changes between the conditions (~condition). Counts
attributed to binding sites are removed from the gene level counts.

Results from both calculation rounds can be filtered and further manipulated
with parameters given in the DESeq2 framework
(see \code{\link[DESeq2]{results}}, \code{\link[DESeq2]{lfcShrink}}).

This function is intended to be used right after a call of \code{\link{filterBsBackground}}.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])

# make example dataset
bds = makeBindingSites(bds, bsSize = 7)
bds = assignToGenes(bds, anno.genes = gns)
bds = imputeBsDifferencesForTestdata(bds)
bds = calculateBsBackground(bds, anno.genes = gns)

# calculate fold changes - no shrinkage
bds = calculateBsFoldChange(bds)

# calculate fold changes - with shrinkage
bds = calculateBsFoldChange(bds, use.lfc.shrinkage = TRUE)

}
\seealso{
\code{\link{calculateBsBackground}},
\code{\link{filterBsBackground}},
\code{\link{plotBsBackgroundFilter}},
\code{\link[DESeq2]{DESeq}}
}
