% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{combineBSF}
\alias{combineBSF}
\title{Combine multiple \code{\link{BSFDataSet}} objects}
\usage{
combineBSF(
  list,
  overlaps.fix = TRUE,
  combine.bsSize = NULL,
  combine.name = NULL,
  force.reload = FALSE,
  quiet = TRUE,
  veryQuiet = FALSE
)
}
\arguments{
\item{list}{list; a list of objects from class \code{\link{BSFDataSet}} that
should be combined}

\item{overlaps.fix}{logical; if partially overlapping binding sites should be
re-centered}

\item{combine.bsSize}{numeric; the binding site size that the merged sites
should have. Default=NULL, then bsSize is taken from the input objects
in \code{list}.}

\item{combine.name}{character; meta table name of the combined object.
Default=NULL; then name is set to 'combined'}

\item{force.reload}{logical; whether the signal should be derived from the
merge of the input objects given in \code{list} or if the signal should be
re-loaded from the path given in the meta data.}

\item{quiet}{logical; whether to print messages or not}

\item{veryQuiet}{logical; whether to print status messages or not}
}
\value{
an object of class \code{\link{BSFDataSet}} with ranges, signal and
meta data resulting from the merge of the input objects.
}
\description{
This function combines all \code{\link{BSFDataSet}} objects from the input
list into a single \code{\link{BSFDataSet}} object.
}
\details{
Meta-data tables are added to each other by performing a row-wise bind,
basically adding all meta data tables underneath each other.

The default way of signal combination is merging all signal lists on the level
of the indivdual samples. One can also force a re-load of the signal list
component by using \code{force.reload=TRUE}.
The signal can be combined by

The ranges are combined by adding both granges objects together. With option
\code{overlaps.fix} one can decide if partially overlapping ranges should be
combined into a single range or not. If this option is FALSE one is likely to
have overlapping binding sites after the merge. If this option is TRUE, then
the combined coverage is used to guide the new center point for these cases.

The \code{combine.bsSize} option allows one to set a unique bsSize for all
objects that should be combined. Although it is recommended to combine only
objects with the same bsSize this option can be used to ensure that the
merged result has the same bsSize for all ranges.

This function is usually used to combine two datasets in the context of a
differntial testing analysis.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

# make binding sites
bds = makeBindingSites(bds, bsSize = 7)

# split ranges in two groups
allRanges = getRanges(bds)
set.seed(1234)
idx = sample(1:length(allRanges), size = length(allRanges)/2, replace = FALSE)
r1 = allRanges[idx]
r2 = allRanges[-idx]

# splite meta data
allMeta = getMeta(bds)
m1 = allMeta[1:2,]
m2 = allMeta[3:4,]

# create new objects
bds1 = setRanges(bds, r1)
bds2 = setRanges(bds, r2)
bds1 = setMeta(bds1, m1)
bds2 = setMeta(bds2, m2)
bds1 = setName(bds1, "test1")
bds2 = setName(bds2, "test2")

# merge two objects with '+' operator
c1 = bds1 + bds2

# merge two objects from list
list = list(bds1, bds2)
c1 = combineBSF(list = list, overlaps.fix = TRUE,
 combine.bsSize = NULL, combine.name = NULL, quiet = TRUE)

}
\seealso{
\code{\link{processingStepsFlowChart}}, \code{\link{calculateBsBackground}}
}
