% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoverageFunctions.R
\name{coverageOverRanges}
\alias{coverageOverRanges}
\title{Coverage function for BSFDataSet objects}
\usage{
coverageOverRanges(
  object,
  returnOptions = c("merge_ranges_keep_positions", "merge_replicates_per_condition",
    "merge_all_replicates", "merge_positions_keep_replicates"),
  method = "sum",
  allowNA = FALSE,
  quiet = TRUE
)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{returnOptions}{one of merge_ranges_keep_positions,
merge_replicates_per_condition, merge_all_replicates,
merge_positions_keep_replicates}

\item{method}{sum/ mean, select how replicates/ ranges should be summarized}

\item{allowNA}{TRUE/ FALSE, allow NA values in the output if input ranges
are of different width}

\item{quiet}{logical, whether to print messages}
}
\value{
an object of class specified in \code{returnOptions}
}
\description{
The crosslink coverage is computed for all ranges in the the given
\code{BSFDataSet} object (see \code{\link{BSFDataSet}} for details).
Depending on the \code{returnOptions} the resulting coverage information is
summarized, suitable for diverse computation and plotting tasks. The
coverage can only be compute for objects with identical ranges.
}
\details{
If \code{returnOptions} is set to merge_ranges_keep_positions:
Returns a matrix with ncol being the nucleotides of the ranges (equal to the
width of the input ranges) and nrow being the number of replicates in the
meta information.

If \code{returnOptions} is set to merge_replicates_per_condition:
Returns a list of matrices. Each list corresponds to one condition set in
the meta information. The matrix in each entry has ncols equal to the
ranges width and nrow equal to the number of ranges. Counts per ranges
and position are summed.

If \code{returnOptions} is set to merge_all_replicates:
Returns a matrix with ncols equal to the range width and nrow equal to the
number of ranges. Counts per range and position are summed.

If \code{returnOptions} is set to merge_positions_keep_replicates:
Returns a GRanges object where the counts are summed for each replicate
and added to the original granges object.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

rng = coverageOverRanges(bds, returnOptions = "merge_ranges_keep_positions")
rng = coverageOverRanges(bds, returnOptions = "merge_replicates_per_condition")
rng = coverageOverRanges(bds, returnOptions = "merge_all_replicates")
rng = coverageOverRanges(bds, returnOptions = "merge_positions_keep_replicates")

}
