% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{exportTargetGenes}
\alias{exportTargetGenes}
\title{Function to export sorted RBP target genes}
\usage{
exportTargetGenes(
  object,
  path = "./",
  format = c("csv", "xslx"),
  sort = c("score", "bs"),
  split = c("none", "geneType", "transcriptRegion")
)
}
\arguments{
\item{object}{a \code{BSFDataSet} object with stored ranges}

\item{path}{A path to where the output should be stored}

\item{format}{output file format}

\item{sort}{sorting rule for genes}

\item{split}{if and how the output file should be split}
}
\value{
a file of the type specified in \code{\link{format}}
}
\description{
Genes with binding sites are target genes of the RBP. They can be exported
as 'csv' or 'xlsx' file. Genes can be sorted by the sum of the individual
binding sites score, or by the number of binding sites per gene.
}
\details{
As output option, one can either output all genes in a single file, or split
by either gene-type or transcript-region. This options requires that either
\code{\link{BSFind}} or the individual functions \code{\link{assignToGenes}},
 and \code{\link{assignToTranscriptRegions}} were run.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
\dontrun{
# export
# exportTargetGenes(bds)
}

}
