% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{geneOverlapsPlot}
\alias{geneOverlapsPlot}
\title{UpSet-plot to that shows the gene type overlaps}
\usage{
geneOverlapsPlot(object, text.size = NULL, show.title = TRUE)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object}

\item{text.size}{numeric; fontsize of all numbers on axis}

\item{show.title}{logical; if plot title should be visible}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
A diagnostic function that plots the gene types of binding sites on overlapping
loci genes. The function \code{\link{assignToGenes}} is expected to be
executed prior to calling this plot function.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
# Load GRanges with genes
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])
bds = makeBindingSites(object = bds, bsSize = 9)
bds = assignToGenes(bds, anno.genes = gns)
geneOverlapsPlot(bds)

}
\seealso{
\code{\link{assignToGenes}} \code{\link{targetGeneSpectrumPlot}}
}
