% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/methods.R
\docType{methods}
\name{getRanges}
\alias{getRanges}
\alias{getRanges,BSFDataSet-method}
\title{Accessor method for the ranges of the BSFDataSet object}
\usage{
getRanges(object)

\S4method{getRanges}{BSFDataSet}(object)
}
\arguments{
\item{object}{a \code{BSFDataSet} object}
}
\value{
returns the genomic ranges (GRanges) of the associated ranges
}
\description{
The ranges slot holds the genomic ranges information of the sites currently
in the object. They are encoded as a GRanges object with each binding site
having a single ranges entry.
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

getRanges(bds)

}
\seealso{
\code{\link{BSFDataSet}}
}
