% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differentialPlots.R
\name{plotBsBackgroundFilter}
\alias{plotBsBackgroundFilter}
\title{Diagnostic plots for the differential binding background}
\usage{
plotBsBackgroundFilter(
  object,
  filter = c("minCounts", "balanceBackground", "balanceCondition")
)
}
\arguments{
\item{object}{a \code{\link{BSFDataSet}} object with background counts filtered
by \code{\link{filterBsBackground}}}

\item{filter}{character; which filter to display in the plot (one of:
'minCounts', 'balanceBackground', 'balanceCondition')}
}
\value{
a plot of type \code{\link{ggplot}}
}
\description{
To perform differential binding analysis between two conditions the
\code{\link{calculateBsBackground}} function groups crosslinks per gene
into those from binding sites and those from background regions.
The \code{\link{filterBsBackground}} function perfroms certain
filtering operations on that background to ensure that it's suitable
for differential testing. This function visually displays the effect
of these filtering operations.
}
\examples{
# load clip data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
load(list.files(files, pattern = ".rds$", full.names = TRUE)[1])

# make testset
bds = makeBindingSites(bds, bsSize = 7)
bds = assignToGenes(bds, anno.genes = gns)
bds = imputeBsDifferencesForTestdata(bds)
bds = calculateBsBackground(bds, anno.genes = gns, use.offset = FALSE)

# use all filters and remove binding sites that fail (default settings)
bds = filterBsBackground(bds)

# display minCount filter
plotBsBackgroundFilter(bds, filter = "minCounts")

# display balance background filter
plotBsBackgroundFilter(bds, filter = "balanceBackground")

# display balance condition filter
plotBsBackgroundFilter(bds, filter = "balanceCondition")

}
\seealso{
\code{\link{calculateBsBackground}}

\code{\link{filterBsBackground}}
}
