% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{rangeCoveragePlot}
\alias{rangeCoveragePlot}
\title{Plot crosslink event coverage over binding site range}
\usage{
rangeCoveragePlot(
  object,
  width = 20,
  show.samples = FALSE,
  subset.chromosome = "chr1",
  quiet = TRUE
)
}
\arguments{
\item{object}{a BSFDataSet, or a list of BSFDataSet}

\item{width}{numeric; set the plotting range to show (in nt)}

\item{show.samples}{logical; to show individual samples as lines}

\item{subset.chromosome}{character; subset by a all ranges on the indicated
chromosome. Can also be a vector with multiple chromosomes. If NULL then all
ranges are being used.}

\item{quiet}{logical; whether to print messages}
}
\value{
a plot of type \code{ggplot2} displaying the crosslink coverage over
the ranges of the given \code{\link{BSFDataSet}}
}
\description{
A diagnostic plot function that allows to check the coverage of crosslink
events over different merged regions. The coverage is shown as mean over all
replicates and conditions, with a standard deviation corridor.
}
\details{
If \code{object} is a single BSFDataObject a single coverage plot will be
drawn, whereas if it is a list of BSFDataObjects, then faceting is used to
make a plot for each list element.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

# plotting a single object
bds <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 1)
rangeCoveragePlot(bds, subset.chromosome = "chr22")

# plotting multiple objects
bds1 <- makeBindingSites(object = bds, bsSize = 3, minWidth = 2,
minCrosslinks = 2, minClSites = 1, sub.chr = "chr22")
bds2 <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 1, sub.chr = "chr22")
l = list(`1. bsSize = 3` = bds1, `2. bsSize = 9` = bds2)
rangeCoveragePlot(l, subset.chromosome = "chr22")

}
\seealso{
\code{\link{BSFDataSet}}, \code{\link{makeBindingSites}}
}
