% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{reproducibilityCutoffPlot}
\alias{reproducibilityCutoffPlot}
\title{Plot to that shows how many replicates support each binding site}
\usage{
reproducibilityCutoffPlot(
  object,
  cutoff = 0.05,
  min.crosslinks = 1,
  max.range = 20,
  ...
)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{cutoff}{a vector of length = 1, or of length = levels(meta$conditions)
with a single number (between 0-1) indicating the quantile cutoff}

\item{min.crosslinks}{numeric of length = 1, defines the lower boundary for
the minimum number of crosslinks a binding site has to be supported by all
replicates, regardless of the replicate specific quantile threshold}

\item{max.range}{maximum number of crosslinks per sites that should be shown}

\item{...}{further arguments passed to ggplot}
}
\value{
a plot of type \code{ggplot2} showing the per replicate
reproducibility cutoffs based on a given quantile threshold
}
\description{
Plotting function for settings specified in
\code{\link{reproducibilityFilter}}.
}
\examples{

# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

# merge binding sites
bds <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 1)

# use the same cutoff for both conditions
suppressWarnings(reproducibilityCutoffPlot(bds, max.range = 20, cutoff = c(0.05)))

# use different cutoffs for each condition
suppressWarnings(reproducibilityCutoffPlot(bds, max.range = 20, cutoff = c(0.1)))


}
\seealso{
\code{\link{reproducibilityFilter}}
}
