% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{reproducibilityScatterPlot}
\alias{reproducibilityScatterPlot}
\title{Plot that shows binding site reproducibility as scatter}
\usage{
reproducibilityScatterPlot(object, quiet = FALSE)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{quiet}{logical; whether to print messages}
}
\value{
an object of class \code{ggplot2}
}
\description{
Function compute the number of crosslinks per binding site on a log2 scale
for each sample. Samples are pairwise correlated as a scatter and pairwise
pearson correlation is shown.
}
\details{
Unlike most plotting functions, this function is actively calculating the
values to plot.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))
bds <- makeBindingSites(object = bds, bsSize = 9, minWidth = 2,
minCrosslinks = 2, minClSites = 3, sub.chr = "chr22")
reproducibilityScatterPlot(bds)

}
\seealso{
\code{\link{BSFind}},
\code{\link{reproducibilityFilter}}
}
