% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunction.R
\name{supportRatioPlot}
\alias{supportRatioPlot}
\title{Plot that shows the binding site support ratio}
\usage{
supportRatioPlot(object, bsWidths, bsFlank = NA, ...)
}
\arguments{
\item{object}{a BSFDataSet object}

\item{bsWidths}{a numeric vector indicating the different binding site
width to compute the ratio for}

\item{bsFlank}{optional; a numeric vector of the same length as
\code{bsWidth} used to specify the width of the flanking regions}

\item{...}{further arguments passed to \code{makeBindingSites}}
}
\value{
an object of class \code{ggplot2}
}
\description{
Function that shows a ratio to determine how well a given binding
site with is supported by the crosslink coverage of the data.
Ratios are computed using the \code{\link{supportRatio}} function.
}
\details{
The higher the ratio, the more does the given binding site width captures
the enrichment of crosslinks compared the the local surrounding. A ratio
equal to 1 would mean no enrichemnt at all.
}
\examples{
# load data
files <- system.file("extdata", package="BindingSiteFinder")
load(list.files(files, pattern = ".rda$", full.names = TRUE))

suppressWarnings(supportRatioPlot(bds, bsWidths = c(3,7),
minWidth = 1, minClSites = 1, minCrosslinks = 2))

}
