% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{CrossValParams}
\alias{CrossValParams}
\alias{CrossValParams-class}
\title{Parameters for Cross-validation Specification}
\usage{
CrossValParams(
  samplesSplits = c("Permute k-Fold", "Permute Percentage Split", "Leave-k-Out",
    "k-Fold"),
  permutations = 100,
  percentTest = 25,
  folds = 5,
  leave = 2,
  tuneMode = c("Resubstitution", "Nested CV", "none"),
  adaptiveResamplingDelta = NULL,
  parallelParams = bpparam()
)
}
\arguments{
\item{samplesSplits}{Default: "Permute k-Fold". A character value
specifying what kind of sample splitting to do.}

\item{permutations}{Default: 100. Number of times to permute the
data set before it is split into training and test sets. Only relevant if
\code{samplesSplits} is either \code{"Permute k-Fold"} or \code{"Permute
Percentage Split"}.}

\item{percentTest}{The percentage of the data
set to assign to the test set, with the remainder of the samples belonging
to the training set. Only relevant if \code{samplesSplits} is \code{"Permute
Percentage Split"}.}

\item{folds}{The number of approximately equal-sized folds to partition
the samples into. Only relevant if \code{samplesSplits} is \code{"Permute k-Fold"}
or \code{"k-Fold"}.}

\item{leave}{The number of samples to generate all possible
combination of and use as the test set.  Only relevant if \code{samplesSplits} is
\code{"Leave-k-Out"}. If set to 1, it is the traditional leave-one-out cross-validation,
sometimes written as LOOCV.}

\item{tuneMode}{Default: Resubstitution. The scheme to use for selecting any tuning parameters.}

\item{adaptiveResamplingDelta}{Default: \code{NULL}. If not null, adaptive resampling of training
samples is performed and this number is the difference in consecutive iterations that the
class probability or risk of all samples must change less than for the iterative process to stop. 0.01
was used in the original publication.}

\item{parallelParams}{An instance of \code{\link{BiocParallelParam}} specifying
the kind of parallelisation to use. Default is to use two cores less than the total number of
cores the computer has, if it has four or more cores, otherwise one core, as is the
default of \code{\link{bpparam}}. To make results fully reproducible, please
choose a specific back-end depending on your operating system and also set
\code{RNGseed} to a number.}
}
\description{
Collects and checks necessary parameters required for cross-validation by
\code{\link{runTests}}.
}
\examples{

  CrossValParams() # Default is 100 permutations and 5 folds of each.
  snow <- SnowParam(workers = 2, RNGseed = 999)
  CrossValParams("Leave-k-Out", leave = 2, parallelParams = snow)
  # Fully reproducible Leave-2-out cross-validation on 4 cores,
  # even if feature selection or classifier use random sampling.

}
\author{
Dario Strbenac
}
