% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crossValidate.R
\name{crossValidate}
\alias{crossValidate}
\alias{crossValidate,matrix-method}
\alias{crossValidate,DataFrame-method}
\alias{crossValidate,MultiAssayExperiment-method,}
\alias{crossValidate,data.frame-method}
\alias{crossValidate,MultiAssayExperimentOrList-method}
\alias{train.matrix}
\alias{train.data.frame}
\alias{train.DataFrame}
\alias{train.list}
\alias{train.MultiAssayExperiment}
\alias{predict.trainedByClassifyR}
\title{Cross-validation to evaluate classification performance.}
\usage{
\S4method{crossValidate}{DataFrame}(
  measurements,
  outcome,
  nFeatures = 20,
  selectionMethod = "auto",
  selectionOptimisation = "Resubstitution",
  performanceType = "auto",
  classifier = "auto",
  multiViewMethod = "none",
  assayCombinations = "all",
  nFolds = 5,
  nRepeats = 20,
  nCores = 1,
  characteristicsLabel = NULL,
  extraParams = NULL,
  verbose = 0
)

\S4method{crossValidate}{MultiAssayExperimentOrList}(
  measurements,
  outcome,
  nFeatures = 20,
  selectionMethod = "auto",
  selectionOptimisation = "Resubstitution",
  performanceType = "auto",
  classifier = "auto",
  multiViewMethod = "none",
  assayCombinations = "all",
  nFolds = 5,
  nRepeats = 20,
  nCores = 1,
  characteristicsLabel = NULL,
  extraParams = NULL,
  verbose = 0
)

\S4method{crossValidate}{data.frame}(
  measurements,
  outcome,
  nFeatures = 20,
  selectionMethod = "auto",
  selectionOptimisation = "Resubstitution",
  performanceType = "auto",
  classifier = "auto",
  multiViewMethod = "none",
  assayCombinations = "all",
  nFolds = 5,
  nRepeats = 20,
  nCores = 1,
  characteristicsLabel = NULL,
  extraParams = NULL,
  verbose = 0
)

\S4method{crossValidate}{matrix}(
  measurements,
  outcome,
  nFeatures = 20,
  selectionMethod = "auto",
  selectionOptimisation = "Resubstitution",
  performanceType = "auto",
  classifier = "auto",
  multiViewMethod = "none",
  assayCombinations = "all",
  nFolds = 5,
  nRepeats = 20,
  nCores = 1,
  characteristicsLabel = NULL,
  extraParams = NULL,
  verbose = 0
)

\method{train}{matrix}(x, outcomeTrain, ...)

\method{train}{data.frame}(x, outcomeTrain, ...)

\method{train}{DataFrame}(
  x,
  outcomeTrain,
  selectionMethod = "auto",
  nFeatures = 20,
  classifier = "auto",
  performanceType = "auto",
  multiViewMethod = "none",
  assayIDs = "all",
  extraParams = NULL,
  verbose = 0,
  ...
)

\method{train}{list}(x, outcomeTrain, ...)

\method{train}{MultiAssayExperiment}(x, outcome, ...)

\method{predict}{trainedByClassifyR}(object, newData, outcome, ...)
}
\arguments{
\item{measurements}{Either a \code{\link{DataFrame}}, \code{\link{data.frame}}, \code{\link{matrix}}, \code{\link{MultiAssayExperiment}} 
or a list of the basic tabular objects containing the data.}

\item{outcome}{A vector of class labels of class \code{\link{factor}} of the
same length as the number of samples in \code{measurements} or a character vector of length 1 containing the
column name in \code{measurements} if it is a \code{\link{DataFrame}}. Or a \code{\link{Surv}} object or a character vector of
length 2 or 3 specifying the time and event columns in \code{measurements} for survival outcome. If \code{measurements} is a
\code{\link{MultiAssayExperiment}}, the column name(s) in \code{colData(measurements)} representing the outcome.  If column names
of survival information, time must be in first column and event status in the second.}

\item{...}{For \code{train} and \code{predict} functions, parameters not used by the non-DataFrame signature functions but passed into the DataFrame signature function.}

\item{nFeatures}{The number of features to be used for classification. If this is a single number, the same number of features will be used for all comparisons
or assays. If a numeric vector these will be optimised over using \code{selectionOptimisation}. If a named vector with the same names of multiple assays, 
a different number of features will be used for each assay. If a named list of vectors, the respective number of features will be optimised over. 
Set to NULL or "all" if all features should be used.}

\item{selectionMethod}{Default: \code{"auto"}. A character vector of feature selection methods to compare. If a named character vector with names corresponding to different assays, 
and performing multiview classification, the respective selection methods will be used on each assay. If \code{"auto"}, t-test (two categories) / F-test (three or more categories) ranking
and top \code{nFeatures} optimisation is done. Otherwise, the ranking method is per-feature Cox proportional hazards p-value. \code{"none"} is also a valid value, meaning that no
indepedent feature selection will be performed (but implicit selection might still happen with the classifier).}

\item{selectionOptimisation}{A character of "Resubstitution", "Nested CV" or "none" specifying the approach used to optimise \code{nFeatures}.}

\item{performanceType}{Performance metric to optimise if classifier has any tuning parameters.}

\item{classifier}{Default: \code{"auto"}. A character vector of classification methods to compare. If a named character vector with names corresponding to different assays, 
and performing multiview classification, the respective classification methods will be used on each assay. If \code{"auto"}, then a random forest is used for a classification
task or Cox proportional hazards model for a survival task.}

\item{multiViewMethod}{Default: \code{"none"}. A character vector specifying the multiview method or data integration approach to use. See \code{available("multiViewMethod") for possibilities.}}

\item{assayCombinations}{A character vector or list of character vectors proposing the assays or, in the case of a list, combination of assays to use
with each element being a vector of assays to combine. Special value \code{"all"} means all possible subsets of assays.}

\item{nFolds}{A numeric specifying the number of folds to use for cross-validation.}

\item{nRepeats}{A numeric specifying the the number of repeats or permutations to use for cross-validation.}

\item{nCores}{A numeric specifying the number of cores used if the user wants to use parallelisation.}

\item{characteristicsLabel}{A character specifying an additional label for the cross-validation run.}

\item{extraParams}{A list of parameters that will be used to overwrite default settings of transformation, selection, or model-building functions or
parameters which will be passed into the data cleaning function. The names of the list must be one of \code{"prepare"},
\code{"select"}, \code{"train"}, \code{"predict"}. To remove one of the defaults (see the article titled Parameter Tuning Presets for crossValidate and Their Customisation on
the website), specify the list element to be \code{NULL}. For the valid element names in the \code{"prepare"} list, see \code{?prepareData}.}

\item{verbose}{Default: 0. A number between 0 and 3 for the amount of
progress messages to give.  A higher number will produce more messages as
more lower-level functions print messages.}

\item{x}{Same as \code{measurements} but only training samples.}

\item{outcomeTrain}{For the \code{train} function, either a factor vector of classes, a \code{\link{Surv}} object, or
a character string, or vector of such strings, containing column name(s) of column(s)
containing either classes or time and event information about survival. If column names
of survival information, time must be in first column and event status in the second.}

\item{assayIDs}{A character vector for assays to train with. Special value \code{"all"}
uses all assays in the input object.}

\item{object}{A fitted model or a list of such models.}

\item{newData}{For the \code{predict} function, an object of type \code{matrix}, \code{data.frame}
\code{DataFrame}, \code{list} (of matrices or data frames) or \code{MultiAssayExperiment} containing
the data to make predictions with with either a fitted model created by \code{train} or the final model
stored in a \code{\link{ClassifyResult}} object.}
}
\value{
An object of class \code{\link{ClassifyResult}}
}
\description{
This function has been designed to facilitate the comparison of classification
methods using cross-validation, particularly when there are multiple assays per biological unit.
A selection of typical comparisons are implemented. The \code{train} function
is a convenience method for training on one data set and likewise \code{predict} for predicting on an
independent validation data set.
}
\details{
\code{classifier} can be any a keyword for any of the implemented approaches as shown by \code{available()}.
\code{selectionMethod} can be a keyword for any of the implemented approaches as shown by \code{available("selectionMethod")}.
\code{multiViewMethod} can be a keyword for any of the implemented approaches as shown by \code{available("multiViewMethod")}.
}
\examples{

data(asthma)

# Compare randomForest and SVM classifiers.
result <- crossValidate(measurements, classes, classifier = c("randomForest", "SVM"))
performancePlot(result)


# Compare performance of different assays. 
# First make a toy example assay with multiple data types. We'll randomly assign different features to be clinical, gene or protein.
# set.seed(51773)
# measurements <- DataFrame(measurements, check.names = FALSE)
# mcols(measurements)$assay <- c(rep("clinical",20),sample(c("gene", "protein"), ncol(measurements)-20, replace = TRUE))
# mcols(measurements)$feature <- colnames(measurements)

# We'll use different nFeatures for each assay. We'll also use repeated cross-validation with 5 repeats for speed in the example.
# set.seed(51773)
#result <- crossValidate(measurements, classes, nFeatures = c(clinical = 5, gene = 20, protein = 30), classifier = "randomForest", nRepeats = 5)
# performancePlot(result)

# Merge different assays. But we will only do this for two combinations. If assayCombinations is not specified it would attempt all combinations.
# set.seed(51773)
# resultMerge <- crossValidate(measurements, classes, assayCombinations = list(c("clinical", "protein"), c("clinical", "gene")), multiViewMethod = "merge", nRepeats = 5)
# performancePlot(resultMerge)


# performancePlot(c(result, resultMerge))

}
