% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precisionPathways.R
\name{calcCostsAndPerformance}
\alias{calcCostsAndPerformance}
\alias{summary.PrecisionPathways}
\alias{bubblePlot.PrecisionPathways}
\alias{flowchart.PrecisionPathways}
\alias{strataPlot.PrecisionPathways}
\title{Various Functions for Evaluating Precision Pathways}
\usage{
calcCostsAndPerformance(precisionPathways, costs = NULL)

\method{summary}{PrecisionPathways}(object, weights = c(accuracy = 0.5, cost = 0.5), ...)

\method{bubblePlot}{PrecisionPathways}(precisionPathways, pathwayColours = NULL, ...)

\method{flowchart}{PrecisionPathways}(
  precisionPathways,
  pathway,
  nodeColours = c(assay = "#86C57C", class1 = "#ACCEE0", class2 = "#F47F72"),
  ...
)

\method{strataPlot}{PrecisionPathways}(
  precisionPathways,
  pathway,
  classColours = c(class1 = "#4DAF4A", class2 = "#984EA3"),
  ...
)
}
\arguments{
\item{precisionPathways}{A pathway of class \code{PrecisionPathways}.}

\item{costs}{A named vector of assays with the cost of each one.}

\item{object}{A set of pathways of class \code{PrecisionPathways}.}

\item{weights}{A numeric vector of length two specifying how to weight the predictive accuracy
and the cost during ranking. Must sum to 1.}

\item{...}{Not used but just following the S3 requirement of the generic template.}

\item{pathwayColours}{A named vector of colours with names being the names of pathways. If none is specified,
a default colour scheme will automatically be chosen.}

\item{pathway}{A chracter vector of length 1 specifying which pathway to plot, e.g. "clinical-mRNA".}

\item{nodeColours}{A named vector of colours with names being \code{"assay"}, \code{"class1"},\code{"class2"}.
a default colour scheme will automatically be chosen.}

\item{classColours}{A named vector of colours with names being \code{"class1"},\code{"class2"}, and \code{"accuracy"}.
a default colour scheme will automatically be chosen.}
}
\description{
These functions tabulate or plot various aspects of precision pathways, such as accuracies and costs.
}
