% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareData.R
\name{prepareData}
\alias{prepareData}
\alias{prepareData,matrix-method}
\alias{prepareData,DataFrame-method}
\alias{prepareData,MultiAssayExperiment-method}
\alias{prepareData,data.frame-method}
\alias{prepareData,list-method}
\title{Convert Different Data Classes into DataFrame and Filter Features}
\usage{
\S4method{prepareData}{matrix}(measurements, outcome, ...)

\S4method{prepareData}{data.frame}(measurements, outcome, ...)

\S4method{prepareData}{DataFrame}(
  measurements,
  outcome,
  useFeatures = NULL,
  maxMissingProp = 0,
  topNvariance = NULL
)

\S4method{prepareData}{MultiAssayExperiment}(measurements, outcomeColumns = NULL, useFeatures = NULL, ...)

\S4method{prepareData}{list}(measurements, outcome = NULL, useFeatures = NULL, ...)
}
\arguments{
\item{measurements}{Either a \code{\link{matrix}}, \code{\link{DataFrame}}
or \code{\link{MultiAssayExperiment}} containing all of the data. For a
\code{matrix} or \code{\link{DataFrame}}, the rows are samples, and the columns
are features.}

\item{...}{Variables not used by the \code{matrix} nor the
\code{MultiAssayExperiment} method which are passed into and used by the
\code{DataFrame} method.}

\item{outcome}{Either a factor vector of classes, a \code{\link{Surv}} object, or
a character string, or vector of such strings, containing column name(s) of column(s)
containing either classes or time and event information about survival. If column names
of survival information, time must be in first column and event status in the second.}

\item{useFeatures}{Default: \code{NULL} (i.e. use all provided features). If \code{measurements} is a \code{MultiAssayExperiment} or list of tabular data,
a named list of features to use. Otherwise, the input data is a single table and this can just be a vector of feature names.
For any assays not in the named list, all of their features are used. \code{"clinical"} is also a valid assay name and refers to the clinical data table.
This allows for the avoidance of variables such spike-in RNAs, sample IDs, sample acquisition dates, etc. which are not relevant for outcome prediction.}

\item{maxMissingProp}{Default: 0.0. A proportion less than 1 which is the maximum
tolerated proportion of missingness for a feature to be retained for modelling.}

\item{topNvariance}{Default: NULL. If \code{measurements} is a \code{MultiAssayExperiment} or list of tabular data, a named integer vector of most variable 
features per assay to subset to. If the input data is a single table, then simply a single integer.
If an assays has less features, it won't be reduced in size but stay as-is.}

\item{outcomeColumns}{If \code{measurements} is a \code{MultiAssayExperiment}, the
names of the column (class) or columns (survival) in the table extracted by \code{colData(data)}
that contain(s) the each individual's outcome to use for prediction.}
}
\value{
A list of length two. The first element is a \code{\link{DataFrame}} of features
and the second element is the outcomes to use for modelling.
}
\description{
Input data could be of matrix, MultiAssayExperiment, or DataFrame format and this
function will prepare a DataFrame of features and a vector of outcomes and help
to exclude nuisance features such as dates or unique sample identifiers from
subsequent modelling.
}
\author{
Dario Strbenac
}
