% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTests.R
\name{runTests}
\alias{runTests}
\alias{runTests,matrix-method}
\alias{runTests,DataFrame-method}
\alias{runTests,MultiAssayExperiment-method}
\title{Reproducibly Run Various Kinds of Cross-Validation}
\usage{
\S4method{runTests}{matrix}(measurements, outcome, ...)

\S4method{runTests}{DataFrame}(
  measurements,
  outcome,
  crossValParams = CrossValParams(),
  modellingParams = ModellingParams(),
  characteristics = S4Vectors::DataFrame(),
  ...,
  verbose = 1
)

\S4method{runTests}{MultiAssayExperiment}(measurements, outcome, ...)
}
\arguments{
\item{measurements}{Either a \code{\link{matrix}}, \code{\link{DataFrame}}
or \code{\link{MultiAssayExperiment}} containing all of the data. For a
\code{matrix} or \code{\link{DataFrame}}, the rows are samples, and the columns
are features.}

\item{...}{Variables not used by the \code{matrix} nor the \code{MultiAssayExperiment} method which
are passed into and used by the \code{DataFrame} method or passed onwards to \code{\link{prepareData}}.}

\item{outcome}{Either a factor vector of classes, a \code{\link{Surv}} object, or
a character string, or vector of such strings, containing column name(s) of column(s)
containing either classes or time and event information about survival. If
\code{measurements} is a \code{MultiAssayExperiment}, the names of the column (class) or
columns (survival) in the table extracted by \code{colData(data)} that contain(s) the samples'
outcome to use for prediction. If column names of survival information, time must be in first
column and event status in the second.}

\item{crossValParams}{An object of class \code{\link{CrossValParams}},
specifying the kind of cross-validation to be done.}

\item{modellingParams}{An object of class \code{\link{ModellingParams}},
specifying the class rebalancing, transformation (if any), feature selection
(if any), training and prediction to be done on the data set.}

\item{characteristics}{A \code{\link{DataFrame}} describing the
characteristics of the classification used. First column must be named
\code{"charateristic"} and second column must be named \code{"value"}.
Useful for automated plot annotation by plotting functions within this
package.  Transformation, selection and prediction functions provided by
this package will cause the characteristics to be automatically determined
and this can be left blank.}

\item{verbose}{Default: 1. A number between 0 and 3 for the amount of
progress messages to give.  A higher number will produce more messages as
more lower-level functions print messages.}
}
\value{
An object of class \code{\link{ClassifyResult}}.
}
\description{
Enables doing classification schemes such as ordinary 10-fold, 100
permutations 5-fold, and leave one out cross-validation. Processing in
parallel is possible by leveraging the package \code{\link{BiocParallel}}.
}
\examples{

  #if(require(sparsediscrim))
  #{
    data(asthma)
    
    CVparams <- CrossValParams(permutations = 5)
    tuneList <- list(nFeatures = seq(5, 25, 5), performanceType = "Balanced Error")
    selectParams <- SelectParams("t-test", tuneParams = tuneList)
    modellingParams <- ModellingParams(selectParams = selectParams)
    runTests(measurements, classes, CVparams, modellingParams,
             DataFrame(characteristic = c("Assay Name", "Classifier Name"),
                       value = c("Asthma", "Different Means"))
             )
  #}

}
\author{
Dario Strbenac
}
