% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RankMerging.R
\name{RankMerging}
\alias{RankMerging}
\title{Merging the ranker lists with the same labels of the biological states into
a single list with the Iorio's method}
\usage{
RankMerging(
  exprSet,
  MergingDistance = c("Spearman", "Kendall"),
  weighted = TRUE
)
}
\arguments{
\item{exprSet}{an ExpressionSet object, each column of assay data represents
a ranked list obtained by preprocessing the corresponding gene expression
profile, and phenotypic data represents the short description
(characteristics of gene expression profile, such as the drug type, the
disease state) about the assay data.}

\item{MergingDistance}{distance to be used which "measures" the similarity
of ordered lists, the default is "Spearman"}

\item{weighted}{there are tow rank merging approaches for two cases: if
\code{weighted = FALSE}, all ranked list with the same biological state are
treated equally important, a simple but useful method average ranking
technique is selected; otherwise, \code{weighted = TRUE}, each individual ranked
lists has its own ranked weights, this takes the iterative
rank-aggregating algorithm, default is \code{TRUE}.}
}
\value{
a \code{\link[Biobase:class.ExpressionSet]{Biobase::ExpressionSet}} object.
}
\description{
Merging the assay data according to phenotypic data of the input
ExpressionSet. Each group of the ranked lists with the same phenotypic data
is aggregated into a single list, return it as an ExpressionSet object.
}
\details{
The krubor function is used in the aggregating procedure. And the
following methods are used in the implementation: a measure of the distance
between two ranked lists (Spearman's Footrule), a method to merge two or
more ranked lists the (Borda Merging Method), and a algorithm to obtain a
single ranked list from a set of them in a hierarchical way (the Kruskal
Algorithm). If choose Kendall as distance, the effectiveness of this
function is certainly limited by the size of the  merging problem.
}
\examples{
# load the sample expressionSet
data(exampleSet)

# Merging each group of the ranked lists in the exampleSet with the same
# phenotypic data into a single PRL
MergingSet <- RankMerging(exampleSet, "Spearman", weighted = TRUE)

}
\seealso{
\code{\link[=SignatureDistance]{SignatureDistance()}}
}
